/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.MekaResultContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import meka.core.Result;

public class MekaResultValues
extends AbstractTransformer {
    private static final long serialVersionUID = 8082115424369061977L;
    protected BaseString[] m_InfoValues;
    protected BaseString[] m_MetricValues;

    public String globalInfo() {
        return "Extracts values from a " + Result.class.getName() + " object and " + "generates a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("info-value", "infoValues", (Object)new BaseString[0]);
        this.m_OptionManager.add("metric-value", "metricValues", (Object)new BaseString[0]);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"infoValues", (Object)(this.m_InfoValues.length == 0 ? "-none-" : Utils.flatten((Object[])this.m_InfoValues, (String)", ")), (String)"info: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"metricValues", (Object)(this.m_MetricValues.length == 0 ? "-none-" : Utils.flatten((Object[])this.m_MetricValues, (String)", ")), (String)", metric: ");
        return result;
    }

    public void setInfoValues(BaseString[] value) {
        this.m_InfoValues = value;
        this.reset();
    }

    public BaseString[] getInfoValues() {
        return this.m_InfoValues;
    }

    public String infoValuesTipText() {
        return "The info values to retrieve.";
    }

    public void setMetricValues(BaseString[] value) {
        this.m_MetricValues = value;
        this.reset();
    }

    public BaseString[] getMetricValues() {
        return this.m_MetricValues;
    }

    public String metricValuesTipText() {
        return "The metric values to retrieve.";
    }

    public Class[] accepts() {
        return new Class[]{Result.class, MekaResultContainer.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        Result res = this.m_InputToken.getPayload() instanceof MekaResultContainer ? (Result)((MekaResultContainer)((Object)this.m_InputToken.getPayload())).getValue("Result") : (Result)this.m_InputToken.getPayload();
        SpreadSheet sheet = new SpreadSheet();
        HeaderRow row = sheet.getHeaderRow();
        row.addCell("K").setContent("Key");
        row.addCell("V").setContent("Value");
        for (BaseString value : this.m_InfoValues) {
            row = sheet.addRow();
            row.addCell("K").setContent(value.getValue());
            row.addCell("V").setContent(res.getInfo(value.getValue()));
        }
        for (BaseString value : this.m_MetricValues) {
            row = sheet.addRow();
            row.addCell("K").setContent(value.getValue());
            row.addCell("V").setContent(Double.valueOf(res.getValue(value.getValue())));
        }
        this.m_OutputToken = new Token((Object)sheet);
        return result;
    }
}

