/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.Utils;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.text.TextContainer;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import nz.ac.waikato.adams.webservice.rats.text.Properties;
import nz.ac.waikato.adams.webservice.rats.text.Property;
import nz.ac.waikato.adams.webservice.rats.text.Text;
import org.apache.commons.io.IOUtils;

public class RatsTextHelper {
    public static Text containerToWebservice(TextContainer input) {
        Text result = new Text();
        result.setData(new DataHandler((DataSource)new ByteArrayDataSource(((String)input.getContent()).getBytes(), "application/octet-stream")));
        Properties props = new Properties();
        if (input.hasReport()) {
            Report report = input.getReport();
            for (AbstractField field : report.getFields()) {
                Property prop = new Property();
                prop.setKey(field.getName());
                prop.setType(nz.ac.waikato.adams.webservice.rats.text.DataType.valueOf(field.getDataType().toRaw()));
                prop.setValue("" + report.getValue(field));
                props.getProp().add(prop);
            }
        }
        result.setProps(props);
        return result;
    }

    public static TextContainer webserviceToContainer(Text input) {
        TextContainer result = new TextContainer();
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)input.getData().getInputStream(), (Writer)writer);
            result.setContent((Object)writer.toString());
        }
        catch (Exception e) {
            result.getNotes().addError(RatsTextHelper.class, Utils.throwableToString((Throwable)e));
        }
        Report report = new Report();
        for (Property prop : input.getProps().getProp()) {
            Field field = new Field(prop.getKey(), DataType.valueOf((String)prop.getType().toString()));
            report.addField((AbstractField)field);
            report.setValue((AbstractField)field, (Object)prop.getValue());
        }
        result.setReport(report);
        return result;
    }
}

