/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.standalone.AbstractStandaloneMutableGroup;
import adams.flow.standalone.Rat;
import java.util.ArrayList;
import java.util.List;

public class Rats
extends AbstractStandaloneMutableGroup<Rat> {
    private static final long serialVersionUID = -6092821156832607603L;

    public String globalInfo() {
        return "Encapsulates all Rat setups.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rat", "rats", (Object)new AbstractActor[0]);
    }

    protected List<Rat> getDefaultActors() {
        return new ArrayList<Rat>();
    }

    public void setRats(AbstractActor[] value) {
        for (int i = 0; i < value.length; ++i) {
            String msg = this.checkActor(value[i], i);
            if (msg == null) continue;
            this.getLogger().warning(msg);
            return;
        }
        this.m_Actors.clear();
        for (AbstractActor actor : value) {
            this.m_Actors.add((Rat)actor);
        }
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getRats() {
        return this.m_Actors.toArray(new AbstractActor[this.m_Actors.size()]);
    }

    public String ratsTipText() {
        return "The reception/transmission setups.";
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, false, ActorExecution.UNDEFINED, false, new Class[]{Rat.class});
    }

    protected String checkActor(AbstractActor actor, int index) {
        if (!(actor instanceof Rat)) {
            return "Setup" + (index > -1 ? " #" + (index + 1) : "") + " is not " + Rat.class.getName() + ", provided: " + actor.getClass().getName();
        }
        return null;
    }

    public String check() {
        return null;
    }

    protected String doExecute() {
        String result = null;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (((Rat)((Object)this.m_Actors.get(i))).getSkip()) continue;
            try {
                result = ((Rat)((Object)this.m_Actors.get(i))).execute();
                if (result == null) continue;
                result = "Rat #" + (i + 1) + " failed: " + result;
                break;
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute Rat #" + (i + 1), e);
            }
        }
        return result;
    }
}

