/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats;

import adams.flow.standalone.rats.AbstractMetaRatInput;
import adams.flow.standalone.rats.PollingRatInput;

public class InputPolling
extends AbstractMetaRatInput
implements PollingRatInput {
    private static final long serialVersionUID = -6499152819821767430L;
    protected int m_WaitPoll;

    public String globalInfo() {
        return "Turns the base-input into one that performs polling every x msec.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("wait-poll", "waitPoll", (Object)1000, (Number)0, null);
    }

    @Override
    public void setWaitPoll(int value) {
        if (value >= 0) {
            this.m_WaitPoll = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    @Override
    public int getWaitPoll() {
        return this.m_WaitPoll;
    }

    @Override
    public String waitPollTipText() {
        return "The number of milli-seconds to wait before polling again.";
    }

    @Override
    public Class generates() {
        return this.m_Input.generates();
    }
}

