/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.FlowFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.ExternalActorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.AbstractMetaRatOutput;
import java.util.ArrayList;

public class OutputWithExternalTransformer
extends AbstractMetaRatOutput
implements ExternalActorHandler {
    private static final long serialVersionUID = -4073060833120998241L;
    protected FlowFile m_ActorFile;
    protected AbstractActor m_ExternalActor;

    public String globalInfo() {
        return "Meta-transmitter that passes the data through the external transformer before forwarding it to the base-transmitter.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "actorFile", (Object)new FlowFile("."));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"actorFile", (Object)this.m_ActorFile);
    }

    public void setActorFile(FlowFile value) {
        this.m_ActorFile = value;
        this.reset();
    }

    public FlowFile getActorFile() {
        return this.m_ActorFile;
    }

    public String actorFileTipText() {
        return "The file containing the external transformer.";
    }

    public String setUpExternalActor() {
        String result = null;
        if (!this.m_ActorFile.isFile()) {
            result = "'" + this.m_ActorFile.getAbsolutePath() + "' does not point to a file!";
        } else {
            ArrayList errors = new ArrayList();
            this.m_ExternalActor = ActorUtils.read((String)this.m_ActorFile.getAbsolutePath(), errors);
            if (!errors.isEmpty()) {
                result = "Error loading external actor '" + this.m_ActorFile.getAbsolutePath() + "':\n" + Utils.flatten(errors, (String)"\n");
            } else if (this.m_ExternalActor == null) {
                result = "Error loading external actor '" + this.m_ActorFile.getAbsolutePath() + "'!";
            } else {
                String warning;
                this.m_ExternalActor.setParent(this.getOwner());
                this.m_ExternalActor.setHeadless(this.getOwner().isHeadless());
                this.m_ExternalActor.setVariables(this.getOwner().getVariables());
                result = this.m_ExternalActor.setUp();
                if (result == null && (warning = this.m_ExternalActor.getOptionManager().updateVariableValues(true)) != null) {
                    this.getLogger().severe("Updating variables ('" + this.getFullName() + "'/'" + this.m_ActorFile + "') resulted in the following error output " + "(which gets ignored since variables might get initialized later on):\n" + warning);
                }
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.m_ExternalActor != null) {
            return ((InputConsumer)this.m_ExternalActor).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.setUpExternalActor();
        }
        return result;
    }

    public AbstractActor getExternalActor() {
        return this.m_ExternalActor;
    }

    @Override
    protected String preTransmit() {
        String result = super.preTransmit();
        if (result == null && !this.m_ExternalActor.getSkip() && !this.m_ExternalActor.isStopped()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Passing data through '" + this.m_ActorFile + "'");
            }
            Token input = new Token(this.m_Input);
            this.m_Input = null;
            ((InputConsumer)this.m_ExternalActor).input(input);
            result = this.m_ExternalActor.execute();
            if (result == null && ((OutputProducer)this.m_ExternalActor).hasPendingOutput()) {
                Token output = ((OutputProducer)this.m_ExternalActor).output();
                if (output.getPayload() != null) {
                    this.m_Input = output.getPayload();
                }
                if (((OutputProducer)this.m_ExternalActor).hasPendingOutput()) {
                    this.getLogger().warning("Only retrieved first output token!");
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Passed data through '" + this.m_ActorFile + "'");
            }
        }
        return result;
    }

    public void cleanUpExternalActor() {
        if (this.m_ExternalActor != null) {
            this.m_ExternalActor.wrapUp();
            this.m_ExternalActor.cleanUp();
            this.m_ExternalActor = null;
        }
    }
}

