/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats;

import adams.data.text.TextContainer;
import adams.flow.standalone.rats.AbstractRatInput;
import adams.flow.standalone.rats.RatInputUser;
import adams.flow.webservice.WebServiceProvider;
import adams.flow.webservice.text.RatsTextServiceWS;
import java.util.ArrayList;
import java.util.List;

public class WSTextReception
extends AbstractRatInput {
    private static final long serialVersionUID = -3681678330127394451L;
    protected WebServiceProvider m_WebService;
    protected List<TextContainer> m_Data;
    protected int m_WaitPoll;

    public String globalInfo() {
        return "Uses a webservice for retrieving text. Internally polls whether data has arrived.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("web-service", "webService", (Object)this.getDefaultWebService());
        this.m_OptionManager.add("wait-poll", "waitPoll", (Object)50, (Number)0, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Data = new ArrayList<TextContainer>();
    }

    protected WebServiceProvider getDefaultWebService() {
        return new RatsTextServiceWS();
    }

    public void setWebService(WebServiceProvider value) {
        this.m_WebService = value;
        this.m_WebService.setOwner(this.getOwner());
        if (this.m_WebService instanceof RatInputUser) {
            ((RatInputUser)this.m_WebService).setRatInput(this);
        }
        this.reset();
    }

    public WebServiceProvider getWebService() {
        return this.m_WebService;
    }

    public String webServiceTipText() {
        return "The webservice provider to use.";
    }

    public void setWaitPoll(int value) {
        if (value >= 0) {
            this.m_WaitPoll = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    public int getWaitPoll() {
        return this.m_WaitPoll;
    }

    public String waitPollTipText() {
        return "The number of milli-seconds to wait before polling again whether data has arrived.";
    }

    @Override
    public Class generates() {
        return TextContainer.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(TextContainer value) {
        List<TextContainer> list = this.m_Data;
        synchronized (list) {
            this.m_Data.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPendingOutput() {
        List<TextContainer> list = this.m_Data;
        synchronized (list) {
            return this.m_Data.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object output() {
        TextContainer result;
        List<TextContainer> list = this.m_Data;
        synchronized (list) {
            result = this.m_Data.remove(0);
        }
        return result;
    }

    @Override
    protected String doReceive() {
        String result = null;
        if (!this.m_WebService.isRunning()) {
            this.m_WebService.setOwner(this.getOwner());
            if (this.m_WebService instanceof RatInputUser) {
                ((RatInputUser)this.m_WebService).setRatInput(this);
            }
            result = this.m_WebService.start();
        }
        if (result == null) {
            while (this.m_Data.size() > 0 && !this.m_Stopped) {
                this.doWait(this.m_WaitPoll);
            }
        }
        return result;
    }

    @Override
    public void stopExecution() {
        this.m_WebService.stop();
        super.stopExecution();
    }

    @Override
    public void cleanUp() {
        this.m_Data.clear();
        super.cleanUp();
    }
}

