/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.text;

import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.standalone.rats.RatInput;
import adams.flow.standalone.rats.RatInputUser;
import adams.flow.webservice.AbstractWebServiceProvider;
import adams.flow.webservice.text.OwnedByRatsTextServiceWS;
import adams.flow.webservice.text.SimpleRatsTextService;
import javax.xml.ws.Endpoint;
import javax.xml.ws.soap.SOAPBinding;
import nz.ac.waikato.adams.webservice.rats.text.RatsTextService;
import org.apache.cxf.jaxws.EndpointImpl;

public class RatsTextServiceWS
extends AbstractWebServiceProvider
implements RatInputUser {
    private static final long serialVersionUID = -6865165378146103361L;
    protected transient EndpointImpl m_Endpoint;
    protected RatsTextService m_Implementation;
    protected RatInput m_RatInput;

    public String globalInfo() {
        return "Provides a KNIR web service with the following services available:\n- get spectrum\n- put spectrum\n- transform spectrum\nEnable logging to see inbound/outgoing messages.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("implementation", "implementation", (Object)new SimpleRatsTextService());
    }

    public String getDefaultURL() {
        return "http://localhost:9090/RatsTextServicePort";
    }

    @Override
    public void setRatInput(RatInput value) {
        this.m_RatInput = value;
    }

    @Override
    public RatInput getRatInput() {
        return this.m_RatInput;
    }

    public void setImplementation(RatsTextService value) {
        this.m_Implementation = value;
        this.reset();
    }

    public RatsTextService getImplementation() {
        return this.m_Implementation;
    }

    public String implementationTipText() {
        return "The implementation of the webservice to use.";
    }

    protected void doStart() throws Exception {
        RatsTextService implementer = this.m_Implementation instanceof OptionHandler ? (RatsTextService)OptionUtils.shallowCopy((OptionHandler)((OptionHandler)this.m_Implementation), (boolean)false) : (RatsTextService)Utils.deepCopy((Object)this.m_Implementation);
        if (implementer instanceof OwnedByRatsTextServiceWS) {
            ((OwnedByRatsTextServiceWS)((Object)implementer)).setOwner(this);
        }
        this.m_Endpoint = (EndpointImpl)Endpoint.publish((String)this.getURL(), (Object)implementer);
        SOAPBinding binding = (SOAPBinding)this.m_Endpoint.getBinding();
        binding.setMTOMEnabled(true);
        this.configureLogging(this.m_Endpoint);
    }

    protected void doStop() throws Exception {
        if (this.m_Endpoint != null) {
            this.m_Endpoint.getServer().stop();
            this.m_Endpoint = null;
        }
    }
}

