/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.flow.webservice.AbstractWebServiceClientTransformer;
import adams.flow.webservice.WebserviceUtils;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import nz.ac.waikato.adams.webservice.weka.CrossValidateClassifier;
import nz.ac.waikato.adams.webservice.weka.CrossValidateResponseObject;
import nz.ac.waikato.adams.webservice.weka.Dataset;
import nz.ac.waikato.adams.webservice.weka.WekaService;
import nz.ac.waikato.adams.webservice.weka.WekaServiceService;

public class CrossValidationClassifier
extends AbstractWebServiceClientTransformer<CrossValidateClassifier, Dataset> {
    private static final long serialVersionUID = -3627934949295336741L;
    protected CrossValidateClassifier m_CrossValidate;
    protected Dataset m_ReturnedDataset;
    protected CrossValidateResponseObject m_Returned;

    public String globalInfo() {
        return "Triggers a cross-validation on the server.";
    }

    public Class[] accepts() {
        return new Class[]{CrossValidateClassifier.class};
    }

    public void setRequestData(CrossValidateClassifier value) {
        this.m_CrossValidate = value;
    }

    public Class[] generates() {
        return new Class[]{Dataset.class};
    }

    public boolean hasResponseData() {
        return this.m_ReturnedDataset != null;
    }

    public Dataset getResponseData() {
        Dataset toReturn = this.m_ReturnedDataset;
        this.m_ReturnedDataset = null;
        return toReturn;
    }

    protected URL getWsdlLocation() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("wsdl/weka/WekaService.wsdl");
    }

    protected void doQuery() throws Exception {
        WekaServiceService wekaServiceService = new WekaServiceService(this.getWsdlLocation());
        WekaService wekaService = wekaServiceService.getWekaServicePort();
        WebserviceUtils.configureClient((Object)wekaService, (int)this.m_ConnectionTimeout, (int)this.m_ReceiveTimeout, (String)(this.getUseAlternativeURL() ? this.getAlternativeURL() : null));
        WebserviceUtils.enableSchemaValidation((BindingProvider)((BindingProvider)wekaService));
        this.m_Returned = wekaService.crossValidateClassifier(this.m_CrossValidate.getDataset(), this.m_CrossValidate.getSeed(), this.m_CrossValidate.getFolds(), this.m_CrossValidate.getClassifier());
        if (this.m_Returned.getErrorMessage() != null) {
            throw new IllegalStateException(this.m_Returned.getErrorMessage());
        }
        this.m_ReturnedDataset = this.m_Returned.getReturnDataset();
        this.m_CrossValidate = null;
    }
}

