/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.data.instance.Instance;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JComponent;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;

public class InstanceExplorerHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -1029811668794627962L;

    public String globalInfo() {
        return "Displays the following WEKA dataset types in the Instance Explorer: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"csv", "arff", "arff.gz", "xrff", "xrff.gz"};
    }

    protected PreviewPanel createPreview(File file) {
        InstancePanel result = new InstancePanel();
        try {
            ArrayList<InstanceContainer> data = new ArrayList<InstanceContainer>();
            Instances dataset = ConverterUtils.DataSource.read((String)file.getAbsolutePath());
            for (int i = 0; i < dataset.numInstances(); ++i) {
                Instance inst = new Instance();
                inst.set(dataset.instance(i));
                inst.setID(i + 1 + "." + dataset.relationName());
                data.add(((InstanceContainerManager)result.getContainerManager()).newContainer((Comparable)((Object)inst)));
            }
            ((InstanceContainerManager)result.getContainerManager()).addAll(data);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load dataset '" + file + "':", e);
        }
        return new PreviewPanel((JComponent)((Object)result));
    }
}

