/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import weka.core.Instance;
import weka.core.Utils;

public class RangeCheckHelper {
    protected static String computePercentage(double value, double min, double max) {
        if (max - min == 0.0) {
            return "N/A";
        }
        if (value < min) {
            return Utils.doubleToString((double)((min - value) / (max - min) * 100.0), (int)2) + "%";
        }
        return Utils.doubleToString((double)((value - max) / (max - min) * 100.0), (int)2) + "%";
    }

    public static String isOutside(Instance inst, int attIndex, double min, double max) {
        if (!inst.attribute(attIndex).isNumeric()) {
            return null;
        }
        double value = inst.value(attIndex);
        if (value < min) {
            return inst.attribute(attIndex).name() + ": " + Utils.doubleToString((double)value, (int)8) + " < " + Utils.doubleToString((double)min, (int)8) + " (" + RangeCheckHelper.computePercentage(value, min, max) + ")";
        }
        if (value > max) {
            return inst.attribute(attIndex).name() + ": " + Utils.doubleToString((double)value, (int)8) + " > " + Utils.doubleToString((double)max, (int)8) + " (" + RangeCheckHelper.computePercentage(value, min, max) + ")";
        }
        return null;
    }
}

