/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.data.weka.rowfinder.AbstractRowFinder;
import java.util.HashSet;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.unsupervised.instance.AbstractRowFinderApplier;

public class DatasetCleaner
extends AbstractRowFinderApplier {
    private static final long serialVersionUID = -111639385529662833L;

    public String globalInfo() {
        return "Removes all rows from the data data that have been indentified.";
    }

    @Override
    public String rowFinderTipText() {
        return "The algorithm for locating rows to be removed from the dataset.";
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat);
    }

    @Override
    protected boolean mayRemoveInstances() {
        return true;
    }

    @Override
    protected Instances apply(Instances data, int[] indices) {
        Instances result = new Instances(data, data.numInstances() - indices.length);
        HashSet<Integer> set = AbstractRowFinder.arrayToHashSet(indices);
        for (int i = 0; i < data.numInstances(); ++i) {
            if (set.contains(i)) continue;
            result.add((Instance)data.instance(i).copy());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 5722 $");
    }
}

