/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Utils;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.File;
import java.util.HashSet;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.ImageMetadata;

public class ImageMetaDataHelper {
    public static final String DATETIME_MASK = "([0-9][0-9][0-9][0-9]):([0-9][0-9]):([0-9][0-9]) ([0-9][0-9]):([0-9][0-9]):([0-9][0-9])";

    protected static String fixDateTime(String s) {
        String result = s.matches(DATETIME_MASK) ? s.replaceAll(DATETIME_MASK, "$1-$2-$3 $4:$5:$6") : s;
        return result;
    }

    public static SpreadSheet getMetaData(File file) throws Exception {
        ImageInfo info;
        String[] parts;
        String value;
        String key;
        SpreadSheet sheet = new SpreadSheet();
        HeaderRow row = sheet.getHeaderRow();
        row.addCell("K").setContent("Key");
        row.addCell("V").setContent("Value");
        HashSet<String> keys = new HashSet<String>();
        IImageMetadata meta = Sanselan.getMetadata((File)file);
        if (meta != null) {
            for (Object item : meta.getItems()) {
                key = null;
                value = null;
                if (item instanceof ImageMetadata.Item) {
                    key = ((ImageMetadata.Item)item).getKeyword().trim();
                    value = ((ImageMetadata.Item)item).getText().trim();
                } else {
                    parts = item.toString().split(": ");
                    if (parts.length == 2) {
                        key = parts[0].trim();
                        value = parts[1].trim();
                    }
                }
                if (key == null || keys.contains(key)) continue;
                keys.add(key);
                row = sheet.addRow();
                row.addCell("K").setContent(key);
                row.addCell("V").setContent(ImageMetaDataHelper.fixDateTime(Utils.unquote((String)value)));
            }
        }
        if ((info = Sanselan.getImageInfo((File)file)) != null) {
            String[] lines;
            String infoStr = info.toString();
            for (String line : lines = infoStr.split(System.lineSeparator())) {
                parts = line.split(": ");
                if (parts.length != 2) continue;
                key = parts[0].trim();
                value = parts[1].trim();
                if (keys.contains(key)) continue;
                row = sheet.addRow();
                row.addCell("K").setContent(key);
                row.addCell("V").setContent(Utils.unquote((String)value));
                keys.add(key);
            }
        }
        return sheet;
    }

    public static SpreadSheet getMetaDataExtractor(File file) throws Exception {
        SpreadSheet sheet = new SpreadSheet();
        HeaderRow row = sheet.getHeaderRow();
        row.addCell("K").setContent("Key");
        row.addCell("V").setContent("Value");
        Metadata metadata = ImageMetadataReader.readMetadata((File)file.getAbsoluteFile());
        for (Directory directory : metadata.getDirectories()) {
            for (Tag tag : directory.getTags()) {
                row = sheet.addRow();
                row.addCell("K").setContent(tag.getTagName());
                row.addCell("V").setContent(ImageMetaDataHelper.fixDateTime(tag.getDescription()));
            }
        }
        return sheet;
    }
}

