/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.flattener;

import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.flattener.AbstractBoofCVFlattener;
import adams.data.image.BufferedImageHelper;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class Pixels
extends AbstractBoofCVFlattener {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Gets all the pixels of the image.";
    }

    @Override
    public Instances createHeader(BoofCVImageContainer img) {
        int numPixels = img.getWidth() * img.getHeight();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < numPixels; ++i) {
            atts.add(new Attribute("att_" + (i + 1)));
        }
        Instances result = new Instances(this.getClass().getName(), atts, 0);
        return result;
    }

    @Override
    public Instance[] doFlatten(BoofCVImageContainer img) {
        Instance[] result = null;
        double[] values = this.newArray(this.m_Header.numAttributes());
        int height = img.getHeight();
        int width = img.getWidth();
        if (img.getImage() instanceof ImageInteger) {
            ImageInteger integer = (ImageInteger)img.getImage();
            for (int n = 0; n < height; ++n) {
                for (int i = 0; i < width; ++i) {
                    values[n * height + i] = integer.get(i, n);
                }
            }
        } else if (img.getImage() instanceof ImageFloat32) {
            ImageFloat32 float32 = (ImageFloat32)img.getImage();
            for (int n = 0; n < height; ++n) {
                for (int i = 0; i < width; ++i) {
                    values[n * height + i] = float32.get(i, n);
                }
            }
        } else if (img.getImage() instanceof ImageFloat64) {
            ImageFloat64 float64 = (ImageFloat64)img.getImage();
            for (int n = 0; n < height; ++n) {
                for (int i = 0; i < width; ++i) {
                    values[n * height + i] = float64.get(i, n);
                }
            }
        } else if (img.getImage() instanceof ImageSInt64) {
            ImageSInt64 sInt64 = (ImageSInt64)img.getImage();
            for (int n = 0; n < height; ++n) {
                for (int i = 0; i < width; ++i) {
                    values[n * height + i] = sInt64.get(i, n);
                }
            }
        } else {
            BufferedImage buff = img.toBufferedImage();
            int[] pixels = BufferedImageHelper.getPixels((BufferedImage)buff);
            for (int i = 0; i < pixels.length; ++i) {
                values[i] = pixels[i];
            }
        }
        result = new Instance[]{new DenseInstance(1.0, values)};
        result[0].setDataset(this.m_Header);
        return result;
    }
}

