/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.flattener;

import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import java.util.ArrayList;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class MultiImageJFlattener
extends AbstractImageJFlattener {
    private static final long serialVersionUID = -4136037171201268286L;
    protected AbstractImageJFlattener[] m_SubFlatteners;
    protected String m_Prefix;
    protected Instances[] m_SubHeaders;

    public String globalInfo() {
        return "Applies multiple flatteners to the same image and merges the generate Instance objects side-by-side. If one of the flatteners should create fewer Instance objects, missing values are used in that case.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sub-flattener", "subFlatteners", (Object)new AbstractImageJFlattener[0]);
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
    }

    public void setSubFlatteners(AbstractImageJFlattener[] value) {
        this.m_SubFlatteners = value;
        this.reset();
    }

    public AbstractImageJFlattener[] getSubFlatteners() {
        return this.m_SubFlatteners;
    }

    public String subFlattenersTipText() {
        return "The flatteners to apply to the image.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for disambiguating the attribute names of the datasets generated by the flatteners; use '@' for the relation name and '#' for the 1-based index of the flattener; examples are: '#-' and '#-@-'";
    }

    protected String createPrefix(int index) {
        String result = this.m_Prefix;
        result = result.replace("@", this.m_SubHeaders[index].relationName());
        result = result.replace("#", "" + (index + 1));
        return result;
    }

    @Override
    public Instances createHeader(ImagePlusContainer img) {
        Instances result;
        int i;
        this.m_SubHeaders = new Instances[this.m_SubFlatteners.length];
        for (i = 0; i < this.m_SubHeaders.length; ++i) {
            this.m_SubHeaders[i] = this.m_SubFlatteners[i].createHeader(img);
        }
        if (!this.m_Prefix.isEmpty()) {
            for (i = 0; i < this.m_SubHeaders.length; ++i) {
                for (int n = 0; n < this.m_SubHeaders[i].numAttributes(); ++n) {
                    String name = this.createPrefix(i) + this.m_SubHeaders[i].attribute(n).name();
                    this.m_SubHeaders[i].renameAttribute(n, name);
                }
            }
        }
        if (this.m_SubHeaders.length > 0) {
            result = new Instances(this.m_SubHeaders[0], 0);
            for (i = 1; i < this.m_SubHeaders.length; ++i) {
                result = Instances.mergeInstances((Instances)result, (Instances)this.m_SubHeaders[i]);
            }
        } else {
            result = new Instances(this.getClass().getSimpleName(), new ArrayList(), 0);
        }
        return result;
    }

    @Override
    public Instance[] doFlatten(ImagePlusContainer img) {
        Instances merged;
        Instance[] flat;
        int i;
        Instances[] sub = new Instances[this.m_SubFlatteners.length];
        for (i = 0; i < this.m_SubFlatteners.length; ++i) {
            flat = this.m_SubFlatteners[i].flatten(img);
            sub[i] = new Instances(this.m_SubHeaders[i]);
            for (int n = 0; n < flat.length; ++n) {
                sub[i].add(flat[n]);
            }
        }
        int max = 0;
        for (i = 0; i < sub.length; ++i) {
            max = Math.max(max, sub[i].numInstances());
        }
        for (i = 0; i < sub.length; ++i) {
            while (sub[i].numInstances() < max) {
                sub[i].add((Instance)new DenseInstance(this.m_SubHeaders[i].numAttributes()));
            }
        }
        if (sub.length > 0) {
            merged = sub[0];
            for (i = 1; i < sub.length; ++i) {
                merged = Instances.mergeInstances((Instances)merged, (Instances)sub[i]);
            }
        } else {
            flat = new Instance[]{new DenseInstance(this.m_Header.numAttributes())};
            merged = new Instances(this.m_Header, 0);
            merged.add(flat[0]);
        }
        Instance[] result = new Instance[merged.numInstances()];
        for (i = 0; i < merged.numInstances(); ++i) {
            result[i] = merged.instance(i);
        }
        return result;
    }
}

