/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.flattener;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import adams.data.imagej.flattener.AbstractScriptedFlattener;
import weka.core.Instance;
import weka.core.Instances;

public class Scripted
extends AbstractScriptedFlattener {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractImageJFlattener m_FlattenerObject;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "An image flattener that uses any scripting handler for processing the data with a script located in the specified file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(AbstractImageJFlattener.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected void checkImage(ImagePlusContainer img) {
        super.checkImage(img);
        this.m_FlattenerObject = (AbstractImageJFlattener)this.m_ScriptObject;
    }

    @Override
    public Instances createHeader(ImagePlusContainer img) {
        return this.m_FlattenerObject.createHeader(img);
    }

    @Override
    public Instance[] doFlatten(ImagePlusContainer img) {
        return this.m_FlattenerObject.flatten(img);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_FlattenerObject = null;
    }
}

