/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import adams.data.jai.transformer.crop.AbstractCropAlgorithm;
import adams.data.jai.transformer.crop.NoCrop;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.awt.image.BufferedImage;

public class Cropping
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected AbstractCropAlgorithm m_Algorithm;

    public String globalInfo() {
        return "Crops the images passing through using the specified crop algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new NoCrop());
    }

    public void setAlgorithm(AbstractCropAlgorithm value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractCropAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The crop algorithm to apply to the image.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)this.m_Algorithm);
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer result = (BufferedImageContainer)img.getHeader();
        result.setImage((Object)this.m_Algorithm.crop((BufferedImage)img.getImage()));
        Report report = result.getReport();
        if (report != null) {
            report.addField((AbstractField)new Field("Crop.Left", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Top", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Right", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Bottom", DataType.NUMERIC));
            report.setNumericValue("Crop.Left", this.m_Algorithm.getTopLeft().getX());
            report.setNumericValue("Crop.Top", this.m_Algorithm.getTopLeft().getY());
            report.setNumericValue("Crop.Right", this.m_Algorithm.getBottomRight().getX());
            report.setNumericValue("Crop.Bottom", this.m_Algorithm.getBottomRight().getY());
        }
        return new BufferedImageContainer[]{result};
    }
}

