/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.image.AbstractImage;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiTransformer
extends AbstractJAITransformer {
    private static final long serialVersionUID = 7793661256600883689L;
    protected AbstractJAITransformer[] m_Transformers;

    public String globalInfo() {
        return "Applies the specified JAI transformers one after the other.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformers", (Object)new AbstractJAITransformer[0]);
    }

    public void setTransformers(AbstractJAITransformer[] value) {
        this.m_Transformers = value;
        this.reset();
    }

    public AbstractJAITransformer[] getTransformers() {
        return this.m_Transformers;
    }

    public String transformersTipText() {
        return "The transformers to apply one after the other.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(img);
        ArrayList<Object> input = new ArrayList<Object>();
        for (int i = 0; i < this.m_Transformers.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Transformer #" + (i + 1) + "...");
            }
            input.clear();
            input.addAll(result);
            result.clear();
            for (BufferedImageContainer bufferedImageContainer : input) {
                result.addAll(Arrays.asList(this.m_Transformers[i].transform((AbstractImage)bufferedImageContainer)));
            }
        }
        return result.toArray(new BufferedImageContainer[result.size()]);
    }
}

