/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import adams.data.jai.transformer.subimages.AbstractSubImagesGenerator;
import adams.data.jai.transformer.subimages.PassThrough;
import java.util.List;

public class SubImages
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected AbstractSubImagesGenerator m_Generator;

    public String globalInfo() {
        return "Produces subimages from the input image using the specified generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new PassThrough());
    }

    public void setGenerator(AbstractSubImagesGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractSubImagesGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for generating the subimages.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator));
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        List<BufferedImageContainer> result = this.m_Generator.process(img);
        return result.toArray(new BufferedImageContainer[result.size()]);
    }
}

