/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer.crop;

import adams.data.image.BufferedImageHelper;
import adams.data.jai.transformer.crop.AbstractCropAlgorithm;
import adams.data.statistics.StatUtils;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class BinaryCrop
extends AbstractCropAlgorithm {
    private static final long serialVersionUID = -696539737461589970L;
    protected int m_NumCheckPoints;

    public String globalInfo() {
        return "Turns image into binary (ie black and white) image and determines largest rectangle in the middle to crop to.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-check-points", "numCheckPoints", (Object)1, (Number)1, null);
    }

    public void setNumCheckPoints(int value) {
        if (value > 0) {
            this.m_NumCheckPoints = value;
            this.reset();
        } else {
            this.getLogger().severe("Number of check points has to be >0, provided: " + value);
        }
    }

    public int getNumCheckPoints() {
        return this.m_NumCheckPoints;
    }

    public String numCheckPointsTipText() {
        return "The number of check points (evenly distributed across width/height) to use for locating the smallest rectangle in the middle.";
    }

    @Override
    protected BufferedImage doCrop(BufferedImage img) {
        int n;
        BufferedImage binary = BufferedImageHelper.convert((BufferedImage)img, (int)12);
        int width = img.getWidth();
        int height = img.getHeight();
        int[] xCheck = new int[this.m_NumCheckPoints];
        int[] yCheck = new int[this.m_NumCheckPoints];
        int[] top = new int[this.m_NumCheckPoints];
        int[] bottom = new int[this.m_NumCheckPoints];
        int[] left = new int[this.m_NumCheckPoints];
        int[] right = new int[this.m_NumCheckPoints];
        for (n = 0; n < this.m_NumCheckPoints; ++n) {
            xCheck[n] = width / (this.m_NumCheckPoints + 1) * (n + 1);
            yCheck[n] = height / (this.m_NumCheckPoints + 1) * (n + 1);
        }
        for (n = 0; n < this.m_NumCheckPoints; ++n) {
            int i;
            top[n] = 0;
            for (i = 0; i < yCheck[n]; ++i) {
                if ((binary.getRGB(xCheck[n], i) >> 0 & 0xFF) <= 0) continue;
                top[n] = i;
                break;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("top[" + n + "]: " + top);
            }
            bottom[n] = height - 1;
            for (i = height - 1; i >= yCheck[n]; --i) {
                if ((binary.getRGB(xCheck[n], i) >> 0 & 0xFF) <= 0) continue;
                bottom[n] = i;
                break;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("bottom[" + n + "]: " + bottom);
            }
            left[n] = 0;
            for (i = 0; i < xCheck[n]; ++i) {
                if ((binary.getRGB(i, yCheck[n]) >> 0 & 0xFF) <= 0) continue;
                left[n] = i;
                break;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("left[" + n + "]: " + left);
            }
            right[n] = width - 1;
            for (i = width - 1; i >= xCheck[n]; --i) {
                if ((binary.getRGB(i, yCheck[n]) >> 0 & 0xFF) <= 0) continue;
                right[n] = i;
                break;
            }
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().fine("right[" + n + "]: " + right);
        }
        int aleft = StatUtils.max((int[])left);
        int aright = StatUtils.min((int[])right);
        int atop = StatUtils.max((int[])top);
        int abottom = StatUtils.min((int[])bottom);
        this.m_TopLeft = new Point(aleft, atop);
        this.m_BottomRight = new Point(aright, abottom);
        BufferedImage image = img.getSubimage(aleft, atop, aright - aleft + 1, abottom - atop + 1);
        return image;
    }
}

