/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer.crop;

import adams.data.image.AbstractImage;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.IndexedColors;
import adams.data.jai.transformer.crop.AbstractCropAlgorithm;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class RectangleCrop
extends AbstractCropAlgorithm {
    private static final long serialVersionUID = -696539737461589970L;

    public String globalInfo() {
        return "Turns the image into one with only two indexed colors and then determines from all four sides the locations where the color changes from the one on the edge. The image is then cropped to this rectangle.";
    }

    @Override
    protected BufferedImage doCrop(BufferedImage img) {
        int bottom;
        int top;
        int right;
        int left;
        int colorNew;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("orig.width=" + img.getWidth() + ", orig.height=" + img.getHeight());
        }
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)img);
        IndexedColors indexed = new IndexedColors();
        indexed.setNumColors(2);
        BufferedImage image = (BufferedImage)((BufferedImageContainer[])indexed.transform((AbstractImage)cont))[0].getImage();
        int x = 0;
        int y = image.getHeight() / 2;
        int color = image.getRGB(x, y);
        do {
            colorNew = image.getRGB(++x, y);
            left = x;
        } while (color == colorNew && x < image.getWidth() - 1);
        x = image.getWidth() - 1;
        y = image.getHeight() / 2;
        color = image.getRGB(x, y);
        do {
            colorNew = image.getRGB(--x, y);
            right = x;
        } while (color == colorNew && x > 0);
        x = image.getWidth() / 2;
        y = 0;
        color = image.getRGB(x, y);
        do {
            colorNew = image.getRGB(x, ++y);
            top = y;
        } while (color == colorNew && y < image.getHeight() - 1);
        x = image.getWidth() / 2;
        y = image.getHeight() - 1;
        color = image.getRGB(x, y);
        do {
            colorNew = image.getRGB(x, --y);
            bottom = y;
        } while (color == colorNew && y > 0);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("left=" + left + ", top=" + top + ", right=" + right + ", bottom=" + bottom);
        }
        int width = right - left + 1;
        int height = bottom - top + 1;
        this.m_TopLeft = new Point(left, top);
        this.m_BottomRight = new Point(left + width - 1, top + height - 1);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("width=" + width + ", height=" + height);
        }
        image = new BufferedImage(width, height, 2);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                image.setRGB(x, y, img.getRGB(left + x, top + y));
            }
        }
        return image;
    }
}

