/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer.crop;

import adams.data.jai.transformer.crop.AbstractCropAlgorithm;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class SimpleCrop
extends AbstractCropAlgorithm {
    private static final long serialVersionUID = -696539737461589970L;
    protected int m_Top;
    protected int m_Left;
    protected int m_Bottom;
    protected int m_Right;
    protected int m_Height;
    protected int m_Width;

    public String globalInfo() {
        return "Simple cropping algorithm that uses a fixed window. The user either specifies a window height/width (if both non-zero) or the bottom-right corner coordinates apart from the coordinates of the top-left corner.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("top", "top", (Object)0, (Number)0, null);
        this.m_OptionManager.add("left", "left", (Object)0, (Number)0, null);
        this.m_OptionManager.add("bottom", "bottom", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("right", "right", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)0, (Number)0, null);
        this.m_OptionManager.add("width", "width", (Object)0, (Number)0, null);
    }

    public void setTop(int value) {
        if (value >= 0) {
            this.m_Top = value;
            this.reset();
        } else {
            this.getLogger().warning("Top must be >= 0, provided: " + value);
        }
    }

    public int getTop() {
        return this.m_Top;
    }

    public String topTipText() {
        return "The y position of the top-left corner.";
    }

    public void setLeft(int value) {
        if (value >= 0) {
            this.m_Left = value;
            this.reset();
        } else {
            this.getLogger().warning("Left must be >= 0, provided: " + value);
        }
    }

    public int getLeft() {
        return this.m_Left;
    }

    public String leftTipText() {
        return "The x position of the top-left corner.";
    }

    public void setBottom(int value) {
        if (value > 0 || value == -1) {
            this.m_Bottom = value;
            this.reset();
        } else {
            this.getLogger().warning("Bottom must be > 0 or -1 (for image height), provided: " + value);
        }
    }

    public int getBottom() {
        return this.m_Bottom;
    }

    public String bottomTipText() {
        return "The y position of the bottom-right corner; use -1 to use image height.";
    }

    public void setRight(int value) {
        if (value > 0 || value == -1) {
            this.m_Right = value;
            this.reset();
        } else {
            this.getLogger().warning("Right must be > 0 or -1 (for image width), provided: " + value);
        }
    }

    public int getRight() {
        return this.m_Right;
    }

    public String rightTipText() {
        return "The x position of the bottom-right corner; use -1 to use image width.";
    }

    public void setHeight(int value) {
        if (value >= 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().warning("Height must be >= 0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the crop rectangle; ignored if less than 1.";
    }

    public void setWidth(int value) {
        if (value >= 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().warning("Width must be >= 0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the crop rectangle, ignored if less than 1.";
    }

    @Override
    protected BufferedImage doCrop(BufferedImage img) {
        int height;
        int width;
        if (this.m_Width > 0 && this.m_Height > 0) {
            width = this.m_Width == -1 ? img.getWidth() : this.m_Width;
            height = this.m_Height == -1 ? img.getHeight() : this.m_Height;
        } else {
            int right = this.m_Right == -1 ? img.getWidth() : this.m_Right;
            int bottom = this.m_Bottom == -1 ? img.getHeight() : this.m_Bottom;
            width = right - this.m_Left;
            height = bottom - this.m_Top;
        }
        this.m_TopLeft = new Point(this.m_Left, this.m_Top);
        this.m_BottomRight = new Point(this.m_Left + width - 1, this.m_Top + height - 1);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("left=" + this.m_Left + ", top=" + this.m_Top + ", width=" + width + ", height=" + height);
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.setRGB(x, y, img.getRGB(this.m_Left + x, this.m_Top + y));
            }
        }
        return image;
    }
}

