/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer.subimages;

import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.subimages.AbstractSubImagesGenerator;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class Grid
extends AbstractSubImagesGenerator {
    private static final long serialVersionUID = 2488185528644078539L;
    public static final String KEY_COLUMN = "Column";
    public static final String KEY_ROW = "Row";
    protected int m_NumCols;
    protected int m_NumRows;

    public String globalInfo() {
        return "Splits the image using a grid of specified number of columns and rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-cols", "numCols", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-rows", "numRows", (Object)1, (Number)1, null);
    }

    public void setNumCols(int value) {
        if (value >= 1) {
            this.m_NumCols = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of columns must be >= 1, provided: " + value);
        }
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public String numColsTipText() {
        return "The number of columns.";
    }

    public void setNumRows(int value) {
        if (value >= 1) {
            this.m_NumRows = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of rows must be >= 1, provided: " + value);
        }
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of rows.";
    }

    @Override
    protected List<BufferedImageContainer> doProcess(BufferedImageContainer image) {
        ArrayList<BufferedImageContainer> result = new ArrayList<BufferedImageContainer>();
        BufferedImage bimage = (BufferedImage)image.getImage();
        int dw = bimage.getWidth() / this.m_NumCols;
        int dh = bimage.getHeight() / this.m_NumRows;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("height=" + bimage.getHeight() + ", width=" + bimage.getWidth() + ", dh=" + dh + ", dw=" + dw);
        }
        for (int w = 0; w < this.m_NumCols; ++w) {
            int x = w * dw;
            int width = w == this.m_NumCols - 1 ? bimage.getWidth() - x : dw;
            for (int h = 0; h < this.m_NumRows; ++h) {
                int y = h * dh;
                int height = h == this.m_NumRows - 1 ? bimage.getHeight() - y : dh;
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("row=" + h + ", col=" + w + ", x=" + x + ", y=" + y + ", width=" + width + ", height=" + height);
                }
                BufferedImageContainer cont = (BufferedImageContainer)image.getHeader();
                cont.setImage((Object)bimage.getSubimage(x, y, width, height));
                cont.getReport().setNumericValue(KEY_COLUMN, (double)w);
                cont.getReport().setNumericValue(KEY_ROW, (double)h);
                result.add(cont);
            }
        }
        return result;
    }
}

