/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.data.container.DataPoint;
import adams.data.image.BufferedImageHelper;
import adams.flow.sink.sequenceplotter.SequencePlotContainer;
import adams.flow.sink.sequenceplotter.SequencePlotContainerManager;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.StickPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;

public class HistogramPanel
extends BasePanel {
    private static final long serialVersionUID = -8621818594275641231L;
    protected GridLayout m_Layout;
    protected BufferedImage m_Image;

    protected void initGUI() {
        super.initGUI();
        this.m_Layout = new GridLayout(0, 1);
        this.setLayout(this.m_Layout);
    }

    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    protected SequencePlotterPanel newPanel(String name) {
        SequencePlotterPanel result = new SequencePlotterPanel(name);
        result.setSidePanelVisible(false);
        result.setPaintlet((XYSequencePaintlet)new StickPaintlet());
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(10);
        result.getPlot().getAxis(Axis.LEFT).setTickGenerator((TickGenerator)tick);
        result.getPlot().getAxis(Axis.LEFT).setNthValueToShow(3);
        result.getPlot().getAxis(Axis.LEFT).setNumberFormat("0");
        result.getPlot().getAxis(Axis.LEFT).setAxisName("");
        tick = new FancyTickGenerator();
        tick.setNumTicks(20);
        result.getPlot().getAxis(Axis.BOTTOM).setTickGenerator((TickGenerator)tick);
        result.getPlot().getAxis(Axis.BOTTOM).setNthValueToShow(5);
        result.getPlot().getAxis(Axis.BOTTOM).setNumberFormat("0");
        result.getPlot().getAxis(Axis.BOTTOM).setAxisName("");
        result.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.01);
        result.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.01);
        result.setPreferredSize(new Dimension(600, 200));
        return result;
    }

    protected void update() {
        boolean gray;
        this.removeAll();
        if (this.m_Image == null) {
            this.m_Layout.setRows(0);
            return;
        }
        boolean bl = gray = this.m_Image.getType() == 10 || this.m_Image.getType() == 12;
        if (gray) {
            this.m_Layout.setRows(1);
        } else {
            this.m_Layout.setRows(3);
        }
        int[][] histogram = BufferedImageHelper.histogram((BufferedImage)this.m_Image, (boolean)gray);
        for (int i = 0; i < histogram.length; ++i) {
            String name;
            switch (i) {
                case 0: {
                    if (gray) {
                        name = "Gray";
                        break;
                    }
                    name = "Red";
                    break;
                }
                case 1: {
                    name = "Green";
                    break;
                }
                case 2: {
                    name = "Blue";
                    break;
                }
                default: {
                    name = null;
                }
            }
            if (name == null) continue;
            SequencePlotSequence seq = new SequencePlotSequence();
            seq.setID(name);
            for (int n = 0; n < histogram[i].length; ++n) {
                seq.add((DataPoint)new SequencePlotPoint((double)n, (double)histogram[i][n]));
            }
            SequencePlotterPanel panel = this.newPanel(name);
            SequencePlotContainerManager manager = (SequencePlotContainerManager)panel.getContainerManager();
            SequencePlotContainer cont = manager.newContainer((Comparable)seq);
            manager.add((XYSequenceContainer)cont);
            this.add((Component)panel);
        }
    }

    public void setImage(BufferedImage value) {
        this.m_Image = value;
        this.update();
    }

    public BufferedImage getImage() {
        return this.m_Image;
    }
}

