/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.data.image.AbstractImage;
import adams.data.image.BufferedImageContainer;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.DialogWithButtons;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPluginWithRestore;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;

public class Brightness
extends AbstractImageViewerPluginWithRestore {
    private static final long serialVersionUID = 3286345601880725626L;
    protected adams.data.jai.transformer.Brightness m_Brightness;

    public String getCaption() {
        return "Brightness...";
    }

    public String getIconName() {
        return "brightness.png";
    }

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected String createLogEntry() {
        return "Changing brightness: " + this.m_Brightness.toCommandLine();
    }

    protected String apply(adams.data.jai.transformer.Brightness brightness) {
        String result = null;
        double scale = this.m_CurrentPanel.getScale();
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)this.m_CurrentPanel.getCurrentImage());
        cont.setReport(this.m_CurrentPanel.getAllProperties());
        BufferedImageContainer[] trans = (BufferedImageContainer[])brightness.transform((AbstractImage)cont);
        if (trans.length != 1) {
            result = "Failed to change brightness!";
        } else {
            this.m_CurrentPanel.setCurrentImage((AbstractImage)trans[0]);
            this.m_CurrentPanel.setScale(scale);
        }
        return result;
    }

    protected String doInteract() {
        String result = null;
        BrightnessDialog dialog = this.m_CurrentPanel.getParentDialog() != null ? new BrightnessDialog(this.m_CurrentPanel.getParentDialog()) : new BrightnessDialog(this.m_CurrentPanel.getParentFrame());
        dialog.setOwnerPlugin(this);
        dialog.setBrightness(this.m_Brightness);
        dialog.setLocationRelativeTo((Component)this.m_CurrentPanel);
        dialog.setVisible(true);
        if (dialog.getBrightness() != null) {
            this.m_Brightness = dialog.getBrightness();
            result = this.apply(this.m_Brightness);
        } else {
            result = "";
        }
        return result;
    }

    public static class BrightnessDialog
    extends DialogWithButtons {
        private static final long serialVersionUID = -9194915750729439570L;
        protected Brightness m_Owner;
        protected JTextField m_TextFactor;
        protected JTextField m_TextOffset;
        protected JButton m_ButtonPreview;
        protected JButton m_ButtonOK;
        protected JButton m_ButtonCancel;
        protected adams.data.jai.transformer.Brightness m_Brightness;

        public BrightnessDialog(Dialog owner) {
            super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
        }

        public BrightnessDialog(Frame owner) {
            super(owner, true);
        }

        protected void initGUI() {
            super.initGUI();
            this.setTitle("Brightness");
            ParameterPanel panel = new ParameterPanel();
            this.getContentPane().add((Component)panel, "Center");
            this.m_TextFactor = new JTextField(10);
            panel.addParameter("Factor", (Component)this.m_TextFactor);
            this.m_TextOffset = new JTextField(10);
            panel.addParameter("Offset", (Component)this.m_TextOffset);
            this.m_ButtonPreview = new JButton("Preview");
            this.m_ButtonPreview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrightnessDialog.this.updateSetup();
                    BrightnessDialog.this.preview();
                }
            });
            this.m_PanelButtonsLeft.add(this.m_ButtonPreview);
            this.m_ButtonOK = new JButton("OK");
            this.m_ButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrightnessDialog.this.updateSetup();
                    BrightnessDialog.this.setVisible(false);
                }
            });
            this.m_PanelButtonsRight.add(this.m_ButtonOK);
            this.m_ButtonCancel = new JButton("Cancel");
            this.m_ButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrightnessDialog.this.m_Brightness = null;
                    BrightnessDialog.this.setVisible(false);
                }
            });
            this.m_PanelButtonsRight.add(this.m_ButtonCancel);
        }

        protected void finishInit() {
            super.finishInit();
            this.pack();
            this.setLocationRelativeTo(null);
        }

        public void setOwnerPlugin(Brightness value) {
            this.m_Owner = value;
        }

        public Brightness getOwnerPlugin() {
            return this.m_Owner;
        }

        protected boolean updateSetup() {
            try {
                this.m_Brightness.setFactor(Float.parseFloat(this.m_TextFactor.getText()));
                this.m_Brightness.setOffset(Float.parseFloat(this.m_TextOffset.getText()));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        protected void preview() {
            List backup = this.m_Owner.getBackup();
            this.m_Owner.restore(backup);
            this.m_Owner.apply(this.m_Brightness);
        }

        public void setBrightness(adams.data.jai.transformer.Brightness value) {
            this.m_Brightness = value;
            if (this.m_Brightness == null) {
                this.m_Brightness = new adams.data.jai.transformer.Brightness();
            }
            this.m_TextFactor.setText("" + this.m_Brightness.getFactor());
            this.m_TextOffset.setText("" + this.m_Brightness.getOffset());
        }

        public adams.data.jai.transformer.Brightness getBrightness() {
            return this.m_Brightness;
        }
    }
}

