/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.Utils;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.ImageMetaData;
import adams.flow.transformer.ImageMetaDataExtraction;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPluginWithGOE;
import java.io.File;

public class ImageFileMetaData
extends AbstractImageViewerPluginWithGOE {
    private static final long serialVersionUID = -3146372359577147914L;

    public String getCaption() {
        return "Image file meta-data";
    }

    public String getIconName() {
        return "imagemetadata.png";
    }

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null && panel.getCurrentFile() != null && !panel.isModified();
    }

    protected String createLogEntry() {
        return null;
    }

    protected Class getEditorType() {
        return ImageMetaDataExtraction.class;
    }

    protected Object getDefaultValue() {
        return new ImageMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SpreadSheet process(File file, ImageMetaDataExtraction extractor) throws Exception {
        SpreadSheet sheet;
        block5: {
            sheet = null;
            Token token = new Token((Object)this.m_CurrentPanel.getCurrentFile());
            extractor.input(token);
            try {
                String msg = extractor.execute();
                if (msg == null) {
                    if (extractor.hasPendingOutput()) {
                        token = extractor.output();
                        sheet = (SpreadSheet)token.getPayload();
                        break block5;
                    }
                    throw new Exception("Extractor did not generate any output!");
                }
                throw new Exception(msg);
            }
            finally {
                extractor.cleanUp();
            }
        }
        return sheet;
    }

    protected String process() {
        String result = null;
        if (this.m_CurrentPanel.getCurrentFile() == null || this.m_CurrentPanel.isModified()) {
            return result;
        }
        try {
            SpreadSheet sheet = this.process(this.m_CurrentPanel.getCurrentFile(), (ImageMetaDataExtraction)this.getLastSetup());
            SpreadSheetDialog dialog = this.m_CurrentPanel.getParentDialog() != null ? new SpreadSheetDialog(this.m_CurrentPanel.getParentDialog()) : new SpreadSheetDialog(this.m_CurrentPanel.getParentFrame());
            dialog.setTitle("Meta-data - " + this.m_CurrentPanel.getCurrentFile().getName() + " [" + this.m_CurrentPanel.getCurrentFile().getParent() + "]");
            dialog.setSpreadSheet(sheet);
            dialog.setShowSearch(true);
            dialog.setSize(600, 600);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            result = "Failed to read meta-data from file '" + this.m_CurrentPanel.getCurrentFile() + "': " + Utils.throwableToString((Throwable)e);
        }
        return result;
    }
}

