/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.CCe;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.cc.CNode;
import meka.core.A;
import meka.core.M;
import meka.core.StatUtils;
import mst.Edge;
import mst.EdgeWeightedGraph;
import mst.KruskalMST;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class BCC
extends CCe {
    String m_DependencyType = "Ibf";

    @Override
    public String globalInfo() {
        return "Bayesian Classifier Chains (BCC).\nCreates a maximum spanning tree based on marginal label dependence. Then employs CC.\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Julio H. Zaragoza et al.");
        result.setValue(TechnicalInformation.Field.TITLE, "Bayesian Chain Classifiers for Multidimensional Classification");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "IJCAI'11: International Joint Conference on Artificial Intelligence.");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        return result;
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        this.m_R = new Random(this.getSeed());
        int L = D.classIndex();
        int d = D.numAttributes() - L;
        if (this.getDebug()) {
            System.out.println("Get unconditional dependencies ...");
        }
        double[][] CD = null;
        if (this.m_DependencyType.equals("L")) {
            if (this.getDebug()) {
                System.out.println("The 'LEAD' method for finding conditional dependence.");
            }
            CD = StatUtils.LEAD(D, this.getClassifier(), this.m_R);
        } else {
            if (this.getDebug()) {
                System.out.println("The Frequency method for finding marginal dependence.");
            }
            CD = StatUtils.margDepMatrix(D, this.m_DependencyType);
        }
        if (this.getDebug()) {
            System.out.println(M.toString(CD));
        }
        CD = M.multiply(CD, -1.0);
        if (this.getDebug()) {
            System.out.println("Make a graph ...");
        }
        EdgeWeightedGraph G = new EdgeWeightedGraph(L);
        for (int i = 0; i < L; ++i) {
            for (int j = i + 1; j < L; ++j) {
                Edge e = new Edge(i, j, CD[i][j]);
                G.addEdge(e);
            }
        }
        if (this.getDebug()) {
            System.out.println("Get an MST ...");
        }
        KruskalMST mst = new KruskalMST(G);
        int[][] paM = new int[L][L];
        for (Edge e : mst.edges()) {
            int j = e.either();
            int k = e.other(j);
            paM[j][k] = 1;
            paM[k][j] = 1;
        }
        if (this.getDebug()) {
            System.out.println(M.toString(paM));
        }
        int root = this.getSeed();
        if (this.getDebug()) {
            System.out.println("Make a Tree from Root " + root);
        }
        int[][] paL = new int[L][0];
        int[] visted = new int[L];
        Arrays.fill(visted, -1);
        visted[root] = 0;
        this.treeify(root, paM, paL, visted);
        if (this.getDebug()) {
            for (int i = 0; i < L; ++i) {
                System.out.println("pa_" + i + " = " + Arrays.toString(paL[i]));
            }
        }
        this.m_Chain = Utils.sort((int[])visted);
        if (this.getDebug()) {
            System.out.println("sequence: " + Arrays.toString(this.m_Chain));
        }
        if (this.getDebug()) {
            System.out.println("Build Classifier Tree ...");
        }
        this.nodes = new CNode[L];
        for (int j : this.m_Chain) {
            if (this.getDebug()) {
                System.out.println("\t node h_" + j + " : P(y_" + j + " | x_[1:" + d + "], y_" + Arrays.toString(paL[j]) + ")");
            }
            this.nodes[j] = new CNode(j, null, paL[j]);
            this.nodes[j].build(D, this.m_Classifier);
        }
        if (this.getDebug()) {
            System.out.println(" * DONE * ");
        }
    }

    public void treeify(int root, int[][] paM, int[][] paL, int[] visited) {
        int[] children = new int[]{};
        for (int j = 0; j < paM[root].length; ++j) {
            if (paM[root][j] != 1 || visited[j] >= 0) continue;
            children = A.append(children, j);
            paL[j] = A.append(paL[j], root);
            visited[j] = visited[Utils.maxIndex((int[])visited)] + 1;
        }
        for (int child : children) {
            this.treeify(child, paM, paL, visited);
        }
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tThe way to measure dependencies.\n\tdefault: " + this.m_DependencyType + " (frequencies only)", "X", 1, "-X <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.m_DependencyType = Utils.getOptionPos((char)'X', (String[])options) >= 0 ? Utils.getOption((char)'X', (String[])options) : this.m_DependencyType;
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-X");
        result.add(this.m_DependencyType);
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new BCC(), args);
    }
}

