/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class BRq
extends MultilabelClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 398261703726763108L;
    protected double m_DownSampleRatio = 0.75;
    protected int m_S = 0;
    protected Random m_Random = new Random(this.m_S);
    protected Classifier[] m_MultiClassifiers = null;

    @Override
    public String globalInfo() {
        return "The Binary Relevance Method - Random Subspace ('quick') Version.\nThis version is able to downsample the number of instances across the binary models.\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes, Eibe Frank");
        result.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning Journal");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.VOLUME, "85");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.PAGES, "333-359");
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.testCapabilities(data);
        int c = data.classIndex();
        if (this.getDebug()) {
            System.out.print("-: Creating " + c + " models (" + this.m_Classifier.getClass().getName() + "): ");
        }
        this.m_MultiClassifiers = AbstractClassifier.makeCopies((Classifier)this.m_Classifier, (int)c);
        Instances sub_data = null;
        for (int i = 0; i < c; ++i) {
            int[][] indices = new int[c][c - 1];
            int k = 0;
            for (int j = 0; j < c; ++j) {
                if (j == i) continue;
                indices[i][k++] = j;
            }
            Remove FilterRemove = new Remove();
            FilterRemove.setAttributeIndicesArray(indices[i]);
            FilterRemove.setInputFormat(data);
            FilterRemove.setInvertSelection(true);
            sub_data = Filter.useFilter((Instances)data, (Filter)FilterRemove);
            sub_data.setClassIndex(0);
            sub_data.randomize(this.m_Random);
            int numToRemove = sub_data.numInstances() - (int)Math.round((double)sub_data.numInstances() * this.m_DownSampleRatio);
            int removed = 0;
            for (int m = 0; m < sub_data.numInstances(); ++m) {
                if (!(sub_data.instance(m).classValue() <= 0.0)) continue;
                sub_data.instance(m).setClassMissing();
                if (++removed >= numToRemove) break;
            }
            sub_data.deleteWithMissingClass();
            this.m_MultiClassifiers[i].buildClassifier(sub_data);
            if (!this.getDebug()) continue;
            System.out.print(" " + (i + 1));
        }
        if (this.getDebug()) {
            System.out.println(" :-");
        }
        this.m_InstancesTemplate = new Instances(sub_data, 0);
    }

    protected Instance[] convertInstance(Instance instance, int c) {
        Instance[] FilteredInstances = new Instance[c];
        for (int i = 0; i < c; ++i) {
            FilteredInstances[i] = (Instance)instance.copy();
            FilteredInstances[i].setDataset(null);
            int offset = 0;
            for (int j = 0; j < c; ++j) {
                if (j == i) {
                    offset = 1;
                    continue;
                }
                FilteredInstances[i].deleteAttributeAt(offset);
            }
            FilteredInstances[i].setDataset(this.m_InstancesTemplate);
        }
        return FilteredInstances;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int c = instance.classIndex();
        double[] result = new double[c];
        Instance[] finstances = this.convertInstance(instance, c);
        for (int i = 0; i < c; ++i) {
            result[i] = this.m_MultiClassifiers[i].classifyInstance(finstances[i]);
        }
        return result;
    }

    public void setSeed(int s) {
        this.m_S = s;
        this.m_Random = new Random(this.m_S);
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSets the downsampling ratio\n\tdefault: " + this.m_DownSampleRatio + "\t(% of original)", "P", 1, "-P <value>"));
        newVector.addElement(new Option("\tThe seed value for randomization\n\tdefault: 0", "S", 1, "-S <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'P', (String[])options);
        this.m_DownSampleRatio = tmpStr.length() > 0 ? Double.parseDouble(tmpStr) : 0.75;
        tmpStr = Utils.getOption((char)'S', (String[])options);
        this.m_S = tmpStr.length() > 0 ? Integer.parseInt(tmpStr) : 0;
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-P");
        result.add("" + this.m_DownSampleRatio);
        result.add("-S");
        result.add("" + this.m_S);
        return result.toArray(new String[result.size()]);
    }

    public int getSeed() {
        return this.m_S;
    }

    public String seedTipText() {
        return "The seed value for randomizing the data.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new BRq(), args);
    }
}

