/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.CCUtils;
import meka.core.MLUtils;
import weka.classifiers.AbstractClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class CC
extends MultilabelClassifier
implements Randomizable,
TechnicalInformationHandler {
    private static final long serialVersionUID = 9045384089402626007L;
    protected Link root = null;
    protected int m_S = 0;
    protected int[] m_Chain = null;

    @Override
    public String globalInfo() {
        return "The Classifier Chains Method.For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes, Eibe Frank");
        result.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning Journal");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.VOLUME, "85");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.PAGES, "333-359");
        TechnicalInformation additional = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes, Eibe Frank");
        additional.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "20th European Conference on Machine Learning (ECML 2009). Bled, Slovenia, September 2009");
        additional.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.add(additional);
        return result;
    }

    public void setSeed(int s) {
        this.m_S = s;
    }

    public int getSeed() {
        return this.m_S;
    }

    public String seedTipText() {
        return "The seed value for randomizing the data.";
    }

    public void setChain(int[] chain) {
        this.m_Chain = chain;
    }

    public int[] getChain() {
        return this.m_Chain;
    }

    public String chainTipText() {
        return "This option was meant to be called by other classifiers.";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        int[] indices = this.getChain();
        if (indices == null) {
            indices = MLUtils.gen_indices(L);
            MLUtils.randomize(indices, new Random(this.m_S));
        }
        if (this.getDebug()) {
            System.out.print(":- Chain (");
        }
        this.root = new Link(indices, 0, D);
        if (this.getDebug()) {
            System.out.println(" ) -:");
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        this.root.classify(x);
        return MLUtils.toDoubleArray(x, L);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tThe seed value for randomization\n\tdefault: 0", "S", 1, "-S <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'S', (String[])options);
        this.m_S = tmpStr.length() > 0 ? Integer.parseInt(tmpStr) : 0;
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-S");
        result.add("" + this.m_S);
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new CC(), args);
    }

    protected class Link
    implements Serializable {
        private Link next = null;
        private AbstractClassifier classifier = null;
        public Instances _template = null;
        private int index = -1;
        private int[] excld;
        private int j = 0;

        public Link(int[] chain, int j, Instances train) throws Exception {
            this.j = j;
            this.index = chain[j];
            this.excld = Arrays.copyOfRange(chain, j + 1, chain.length);
            Arrays.sort(this.excld);
            Instances new_train = CCUtils.linkTransform(train, j, this.index, this.excld);
            this._template = new Instances(new_train, 0);
            this.classifier = (AbstractClassifier)AbstractClassifier.forName((String)CC.this.getClassifier().getClass().getName(), (String[])((AbstractClassifier)CC.this.getClassifier()).getOptions());
            this.classifier.buildClassifier(new_train);
            new_train = null;
            if (j + 1 < chain.length) {
                this.next = new Link(chain, ++j, train);
            }
        }

        protected void classify(Instance test) throws Exception {
            Instance copy = (Instance)test.copy();
            copy.setDataset(null);
            for (int i = this.excld.length - 1; i >= 0; --i) {
                copy.deleteAttributeAt(this.excld[i]);
            }
            copy.setDataset(this._template);
            test.setValue(this.index, (double)((int)this.classifier.classifyInstance(copy)));
            if (this.next != null) {
                this.next.classify(test);
            }
        }

        public String toString() {
            return this.next == null ? String.valueOf(this.index) : String.valueOf(this.index) + ">" + this.next.toString();
        }
    }
}

