/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.MLUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class CCq
extends MultilabelClassifier
implements Randomizable,
TechnicalInformationHandler {
    private static final long serialVersionUID = 7881602808389873411L;
    protected double m_DownSampleRatio = 0.75;
    protected int m_S = 0;
    protected Random m_Random = new Random(this.m_S);
    protected int m_NumClasses = -1;
    protected QLink root = null;

    @Override
    public String globalInfo() {
        return "The Classifier Chains  Method - Random Subspace ('quick') Version.\nThis version is able to downsample the number of training instances across the binary models.For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes, Eibe Frank");
        result.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning Journal");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.VOLUME, "85");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.PAGES, "333-359");
        return result;
    }

    public void setSeed(int s) {
        this.m_S = s;
        this.m_Random = new Random(this.m_S);
    }

    public String seedTipText() {
        return "The seed value for randomization.";
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSets the downsampling ratio        \n\tdefault: " + this.m_DownSampleRatio + "\t(% of original)", "P", 1, "-P <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        block2: {
            try {
                this.m_DownSampleRatio = Double.parseDouble(Utils.getOption((char)'P', (String[])options));
            }
            catch (Exception e) {
                if (!this.getDebug()) break block2;
                System.err.println("Using default P = " + this.m_DownSampleRatio);
            }
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 2];
        int current = 0;
        options[current++] = "-P";
        options[current++] = "" + this.m_DownSampleRatio;
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public int getSeed() {
        return this.m_S;
    }

    @Override
    public void buildClassifier(Instances Train) throws Exception {
        this.testCapabilities(Train);
        this.m_NumClasses = Train.classIndex();
        int[] indices = MLUtils.gen_indices(this.m_NumClasses);
        MLUtils.randomize(indices, new Random(this.m_S));
        if (this.getDebug()) {
            System.out.print(":- Chain (");
        }
        this.root = new QLink(indices, 0, Train);
        if (this.getDebug()) {
            System.out.println(" ) -:");
        }
    }

    @Override
    public double[] distributionForInstance(Instance test) throws Exception {
        this.root.classify(test);
        return MLUtils.toDoubleArray(test, this.m_NumClasses);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new CCq(), args);
    }

    protected class QLink {
        private QLink next = null;
        private Classifier classifier = null;
        public Instances _template = null;
        private int index = -1;
        private int[] excld;
        private int j = 0;

        public QLink(int[] chain, int j, Instances train) throws Exception {
            this.j = j;
            this.index = chain[j];
            this.excld = Arrays.copyOfRange(chain, j + 1, chain.length);
            Arrays.sort(this.excld);
            this.classifier = AbstractClassifier.forName((String)CCq.this.getClassifier().getClass().getName(), (String[])((AbstractClassifier)CCq.this.getClassifier()).getOptions());
            Instances new_train = new Instances(train);
            if (CCq.this.getDebug()) {
                System.out.print(" " + this.index);
            }
            new_train.setClassIndex(-1);
            int c_index = chain[j];
            for (int i = this.excld.length - 1; i >= 0; --i) {
                new_train.deleteAttributeAt(this.excld[i]);
                if (this.excld[i] >= this.index) continue;
                --c_index;
            }
            new_train.setClassIndex(c_index);
            new_train.randomize(CCq.this.m_Random);
            int numToRemove = new_train.numInstances() - (int)Math.round((double)new_train.numInstances() * CCq.this.m_DownSampleRatio);
            int removed = 0;
            for (int i = 0; i < new_train.numInstances(); ++i) {
                if (!(new_train.instance(i).classValue() <= 0.0)) continue;
                new_train.instance(i).setClassMissing();
                if (++removed >= numToRemove) break;
            }
            new_train.deleteWithMissingClass();
            this._template = new Instances(new_train, 0);
            this.classifier.buildClassifier(new_train);
            new_train = null;
            if (j + 1 < chain.length) {
                this.next = new QLink(chain, ++j, train);
            }
        }

        private void classify(Instance test) throws Exception {
            Instance copy = (Instance)test.copy();
            copy.setDataset(null);
            for (int i = this.excld.length - 1; i >= 0; --i) {
                copy.deleteAttributeAt(this.excld[i]);
            }
            copy.setDataset(this._template);
            test.setValue(this.index, (double)((int)this.classifier.classifyInstance(copy)));
            if (this.next != null) {
                this.next.classify(test);
            }
        }

        public String toString() {
            return this.next == null ? String.valueOf(this.index) : String.valueOf(this.index) + ">" + this.next.toString();
        }
    }
}

