/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.SemisupervisedClassifier;
import meka.classifiers.multitarget.MultiTargetClassifier;
import meka.core.MLEvalUtils;
import meka.core.MLUtils;
import meka.core.Result;
import weka.core.AbstractInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.SerializationHelper;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;

public class Evaluation {
    public static void runExperiment(MultilabelClassifier h, String[] options) throws Exception {
        int seed;
        if (Utils.getOptionPos((char)'h', (String[])options) >= 0) {
            System.out.println("\nHelp requested");
            Evaluation.printOptions(h.listOptions());
            return;
        }
        h.setOptions(options);
        Instances allInstances = Evaluation.getDataset(options);
        if (allInstances.classIndex() <= 0) {
            Evaluation.setClassesFromOptions(allInstances, options);
        }
        int n = seed = Utils.getOptionPos((char)'s', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'s', (String[])options)) : 0;
        if (Utils.getOptionPos((char)'R', (String[])options) >= 0) {
            boolean R = Utils.getFlag((char)'R', (String[])options);
            allInstances.randomize(new Random(seed));
        }
        if (h instanceof Randomizable) {
            ((Randomizable)h).setSeed(seed + 1);
        }
        String voption = "1";
        if (Utils.getOptionPos((String)"verbosity", (String[])options) >= 0) {
            voption = Utils.getOption((String)"verbosity", (String[])options);
        }
        String fname = null;
        if (Utils.getOptionPos((char)'f', (String[])options) >= 0) {
            fname = Utils.getOption((char)'f', (String[])options);
        }
        String dname = null;
        if (Utils.getOptionPos((char)'d', (String[])options) >= 0) {
            dname = Utils.getOption((char)'d', (String[])options);
        }
        String lname = null;
        if (Utils.getOptionPos((char)'l', (String[])options) >= 0) {
            lname = Utils.getOption((char)'l', (String[])options);
            h = (MultilabelClassifier)((Object)SerializationHelper.read((String)lname));
        }
        try {
            Result r = null;
            String top = "PCut1";
            if (Utils.getOptionPos((String)"threshold", (String[])options) >= 0) {
                top = Utils.getOption((String)"threshold", (String[])options);
            }
            if (Utils.getOptionPos((char)'x', (String[])options) >= 0) {
                int numFolds = MLUtils.getIntegerOption(Utils.getOption((char)'x', (String[])options), 10);
                Utils.checkForRemainingOptions((String[])options);
                Result[] fold = Evaluation.cvModel(h, allInstances, numFolds, top, voption);
                r = MLEvalUtils.averageResults(fold);
                System.out.println(r.toString());
                if (fname != null) {
                    for (int i = 0; i < fold.length; ++i) {
                        Result.writeResultToFile(fold[i], fname + "." + i);
                    }
                }
            } else {
                int TRAIN = -1;
                if (Utils.getOptionPos((char)'T', (String[])options) >= 0) {
                    TRAIN = allInstances.numInstances();
                    try {
                        Instances testInstances = Evaluation.getDataset(options, 'T');
                        for (Instance x : testInstances) {
                            x.setDataset(allInstances);
                            allInstances.add(x);
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("[Error] Failed to Load Test Instances from file.", e);
                    }
                } else if (Utils.getOptionPos((String)"split-percentage", (String[])options) >= 0) {
                    double percentTrain = Double.parseDouble(Utils.getOption((String)"split-percentage", (String[])options));
                    TRAIN = (int)Math.round((double)allInstances.numInstances() * (percentTrain / 100.0));
                } else {
                    TRAIN = Utils.getOptionPos((String)"split-number", (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((String)"split-number", (String[])options)) : (int)((double)allInstances.numInstances() * 0.6);
                }
                int TEST = allInstances.numInstances() - TRAIN;
                Instances train = new Instances(allInstances, 0, TRAIN);
                train.setClassIndex(allInstances.classIndex());
                Instances test = new Instances(allInstances, TRAIN, TEST);
                test.setClassIndex(allInstances.classIndex());
                if (Utils.getFlag((char)'i', (String[])options)) {
                    Instances temp = test;
                    test = train;
                    train = temp;
                }
                Utils.checkForRemainingOptions((String[])options);
                if (h.getDebug()) {
                    System.out.println(":- Dataset -: " + MLUtils.getDatasetName(allInstances) + "\tL=" + allInstances.classIndex() + "\tD(t:T)=(" + train.numInstances() + ":" + test.numInstances() + ")\tLC(t:T)=" + Utils.roundDouble((double)MLUtils.labelCardinality(train, allInstances.classIndex()), (int)2) + ":" + Utils.roundDouble((double)MLUtils.labelCardinality(test, allInstances.classIndex()), (int)2) + ")");
                }
                if (lname != null) {
                    r = Evaluation.testClassifier(h, test);
                    if (h instanceof MultiTargetClassifier || Evaluation.isMT(test)) {
                        r.setInfo("Type", "MT");
                    } else if (h instanceof MultilabelClassifier) {
                        r.setInfo("Type", "ML");
                    }
                    r.setInfo("Threshold", MLEvalUtils.getThreshold(r.predictions, train, top));
                    r.setInfo("Verbosity", voption);
                    r.output = Result.getStats(r, voption);
                } else {
                    r = Evaluation.evaluateModel(h, train, test, top, voption);
                }
                System.out.println(r.toString());
            }
            if (fname != null) {
                Result.writeResultToFile(r, fname);
            }
            if (dname != null) {
                SerializationHelper.write((String)dname, (Object)((Object)h));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Evaluation.printOptions(h.listOptions());
            System.exit(1);
        }
        System.exit(0);
    }

    public static boolean isMT(Instances D) {
        int L = D.classIndex();
        for (int j = 0; j < L; ++j) {
            if (D.attribute(j).isNominal()) {
                if (D.attribute(j).numValues() <= 2) continue;
                return true;
            }
            System.err.println("wtf?");
        }
        return false;
    }

    public static Result evaluateModel(MultilabelClassifier h, Instances D_train, Instances D_test, String top) throws Exception {
        return Evaluation.evaluateModel(h, D_train, D_test, top, "1");
    }

    public static Result evaluateModel(MultilabelClassifier h, Instances D_train, Instances D_test, String top, String vop) throws Exception {
        Result r = Evaluation.evaluateModel(h, D_train, D_test);
        if (h instanceof MultiTargetClassifier || Evaluation.isMT(D_test)) {
            r.setInfo("Type", "MT");
        } else if (h instanceof MultilabelClassifier) {
            r.setInfo("Type", "ML");
        }
        r.setInfo("Threshold", MLEvalUtils.getThreshold(r.predictions, D_train, top));
        r.setInfo("Verbosity", vop);
        r.output = Result.getStats(r, vop);
        return r;
    }

    public static Result[] cvModel(MultilabelClassifier h, Instances D, int numFolds, String top) throws Exception {
        return Evaluation.cvModel(h, D, numFolds, top, "1");
    }

    public static Result[] cvModel(MultilabelClassifier h, Instances D, int numFolds, String top, String vop) throws Exception {
        Result[] r = new Result[numFolds];
        for (int i = 0; i < numFolds; ++i) {
            Instances D_train = D.trainCV(numFolds, i);
            Instances D_test = D.testCV(numFolds, i);
            if (h.getDebug()) {
                System.out.println(":- Fold [" + i + "/" + numFolds + "] -: " + MLUtils.getDatasetName(D) + "\tL=" + D.classIndex() + "\tD(t:T)=(" + D_train.numInstances() + ":" + D_test.numInstances() + ")\tLC(t:T)=" + Utils.roundDouble((double)MLUtils.labelCardinality(D_train, D.classIndex()), (int)2) + ":" + Utils.roundDouble((double)MLUtils.labelCardinality(D_test, D.classIndex()), (int)2) + ")");
            }
            r[i] = Evaluation.evaluateModel(h, D_train, D_test, top, vop);
        }
        return r;
    }

    public static Result evaluateModel(MultilabelClassifier h, Instances D_train, Instances D_test) throws Exception {
        long before = System.currentTimeMillis();
        if (h instanceof SemisupervisedClassifier) {
            ((SemisupervisedClassifier)((Object)h)).setUnlabelledData(MLUtils.setLabelsMissing(new Instances(D_test)));
        }
        h.buildClassifier(D_train);
        long after = System.currentTimeMillis();
        long before_test = System.currentTimeMillis();
        Result result = Evaluation.testClassifier(h, D_test);
        long after_test = System.currentTimeMillis();
        result.setValue("N_train", D_train.numInstances());
        result.setValue("N_test", D_test.numInstances());
        result.setValue("LCard_train", MLUtils.labelCardinality(D_train));
        result.setValue("LCard_test", MLUtils.labelCardinality(D_test));
        result.setValue("Build_time", (double)(after - before) / 1000.0);
        result.setValue("Test_time", (double)(after_test - before_test) / 1000.0);
        result.setValue("Total_time", (double)(after_test - before) / 1000.0);
        result.setInfo("Classifier_name", ((Object)((Object)h)).getClass().getName());
        result.setInfo("Classifier_ops", Arrays.toString(h.getOptions()));
        result.setInfo("Classifier_info", h.toString());
        result.setInfo("Dataset_name", MLUtils.getDatasetName(D_train));
        return result;
    }

    public static Result testClassifier(MultilabelClassifier h, Instances D_test) throws Exception {
        int L = D_test.classIndex();
        Result result = new Result(D_test.numInstances(), L);
        if (h.getDebug()) {
            System.out.print(":- Evaluate ");
        }
        int c = 0;
        for (int i = 0; i < D_test.numInstances(); ++i) {
            int t;
            if (h.getDebug() && (t = i * 50 / D_test.numInstances()) > c) {
                System.out.print("#");
                c = t;
            }
            AbstractInstance x = (AbstractInstance)((AbstractInstance)D_test.instance(i)).copy();
            for (int v = 0; v < D_test.classIndex(); ++v) {
                x.setValue(v, 0.0);
            }
            double[] y = h.distributionForInstance((Instance)x);
            if (h instanceof MultiTargetClassifier) {
                y = Arrays.copyOf(y, L);
            }
            result.addResult(y, D_test.instance(i));
        }
        if (h.getDebug()) {
            System.out.println(":-");
        }
        return result;
    }

    public static Instances getDataset(String[] options, char T) throws Exception {
        Instances D = Evaluation.loadDatasetFromOptions(options, T);
        Evaluation.setClassesFromOptions(D, MLUtils.getDatasetOptions(D));
        return D;
    }

    public static Instances getDataset(String[] options) throws Exception {
        return Evaluation.getDataset(options, 't');
    }

    public static Instances loadDatasetFromOptions(String[] options, char T) throws Exception {
        Instances D = null;
        String filename = Utils.getOption((char)T, (String[])options);
        if (filename == null || filename.isEmpty()) {
            throw new Exception("[Error] You did not specify a dataset!");
        }
        File file = new File(filename);
        if (!file.exists()) {
            throw new Exception("[Error] File does not exist: " + filename);
        }
        if (file.isDirectory()) {
            throw new Exception("[Error] " + filename + " points to a directory!");
        }
        try {
            ConverterUtils.DataSource source = new ConverterUtils.DataSource(filename);
            D = source.getDataSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("[Error] Failed to load Instances from file '" + filename + "'.");
        }
        return D;
    }

    public static int getL(String[] options) throws Exception {
        return Utils.getOptionPos((char)'C', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'C', (String[])options)) : 0;
    }

    public static void setClassesFromOptions(Instances D, String[] options) throws Exception {
        try {
            int L = Evaluation.getL(options);
            if (L < 0) {
                L = -L;
                D = MLUtils.switchAttributes(D, L);
            }
            D.setClassIndex(L);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("[Error] Failed to Set Classes from options. You must supply the number of labels either in the @Relation Name of the dataset or on the command line using the option: -C <num. labels>");
        }
    }

    public static void printOptions(Enumeration e) {
        StringBuffer text = new StringBuffer();
        text.append("\n\nEvaluation Options:\n\n");
        text.append("-h\n");
        text.append("\tOutput help information.\n");
        text.append("-t <name of training file>\n");
        text.append("\tSets training file.\n");
        text.append("-T <name of test file>\n");
        text.append("\tSets test file.\n");
        text.append("-x <number of folds>\n");
        text.append("\tDo cross-validation with this many folds.\n");
        text.append("-R\n");
        text.append("\tRandomise the dataset (done after a range is removed, but before the train/test split).\n");
        text.append("-split-percentage <percentage>\n");
        text.append("\tSets the percentage for the train/test set split, e.g., 66.\n");
        text.append("-split-number <number>\n");
        text.append("\tSets the number of training examples, e.g., 800\n");
        text.append("-i\n");
        text.append("\tInvert the specified train/test split.\n");
        text.append("-s <random number seed>\n");
        text.append("\tSets random number seed.\n");
        text.append("-threshold <threshold>\n");
        text.append("\tSets the type of thresholding; where\n\t\t'PCut1' automatically calibrates a threshold (the default);\n\t\t'PCutL' automatically calibrates one threshold for each label;\n\t\tany double number, e.g. '0.5', specifies that threshold.\n");
        text.append("-C <number of classes/labels>\n");
        text.append("\tSets the number of target attributes (classes/labels) to expect (indexed from the beginning).\n");
        text.append("-f <results_file>\n");
        text.append("\tSpecify a file to output results and evaluation statistics into.\n");
        text.append("-d <classifier_file>\n");
        text.append("\tSpecify a file to dump classifier into.\n");
        text.append("-l <classifier_file>\n");
        text.append("\tSpecify a file to load classifier from.\n");
        text.append("-verbosity <verbosity level>\n");
        text.append("\tSpecify more/less evaluation output\n");
        text.append("\n\nClassifier Options:\n\n");
        while (e.hasMoreElements()) {
            Option o = (Option)e.nextElement();
            text.append("-" + o.name() + '\n');
            text.append("" + o.description() + '\n');
        }
        System.out.println(text);
    }
}

