/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.MLUtils;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class LC
extends MultilabelClassifier
implements OptionHandler {
    private static final long serialVersionUID = -2726090581435923988L;

    @Override
    public String globalInfo() {
        return "LC aka LP (Laber Powerset) Method.\nTreats each label combination as a single class in a multi-class learning scheme. The set of possible values of each class is the powerset of labels.\nSee also LP from MULAN:\nhttp://mulan.sourceforge.net";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        FastVector ClassValues = new FastVector(L);
        HashSet<String> UniqueValues = new HashSet<String>();
        for (int i = 0; i < D.numInstances(); ++i) {
            UniqueValues.add(MLUtils.toBitString(D.instance(i), L));
        }
        Iterator it = UniqueValues.iterator();
        while (it.hasNext()) {
            ClassValues.addElement(it.next());
        }
        Attribute Y_new = new Attribute("Class", (List)ClassValues);
        Remove FilterRemove = new Remove();
        FilterRemove.setAttributeIndices("1-" + L);
        FilterRemove.setInputFormat(D);
        Instances NewTrain = Filter.useFilter((Instances)D, (Filter)FilterRemove);
        NewTrain.insertAttributeAt(Y_new, 0);
        NewTrain.setClassIndex(0);
        for (int i = 0; i < NewTrain.numInstances(); ++i) {
            String comb = MLUtils.toBitString(D.instance(i), L);
            NewTrain.instance(i).setClassValue(comb);
        }
        this.m_InstancesTemplate = new Instances(NewTrain, 0);
        if (this.getDebug()) {
            System.out.println("(" + this.m_InstancesTemplate.attribute(0).numValues() + " classes, " + NewTrain.numInstances() + " ins. )");
        }
        if (this.getDebug()) {
            System.out.print("Building Classifier " + this.m_Classifier.getClass() + " with " + ClassValues.size() + " possible classes .. ");
        }
        this.m_Classifier.buildClassifier(NewTrain);
        if (this.getDebug()) {
            System.out.println("Done");
        }
    }

    public Instance convertInstance(Instance x, int L) {
        Instance x_ = (Instance)x.copy();
        x_.setDataset(null);
        for (int i = 0; i < L; ++i) {
            x_.deleteAttributeAt(0);
        }
        x_.insertAttributeAt(0);
        x_.setDataset(this.m_InstancesTemplate);
        return x_;
    }

    public double[] convertDistribution(double[] p, int L) {
        double[] y = new double[L];
        int i = Utils.maxIndex((double[])p);
        double[] d = MLUtils.fromBitString(this.m_InstancesTemplate.classAttribute().value(i));
        for (int j = 0; j < d.length; ++j) {
            if (!(d[j] > 0.0)) continue;
            y[j] = 1.0;
        }
        return y;
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        if (L == 1) {
            return new double[]{1.0};
        }
        Instance slInstance = this.convertInstance(x, L);
        slInstance.setDataset(this.m_InstancesTemplate);
        double[] y = new double[slInstance.numClasses()];
        y[(int)this.m_Classifier.classifyInstance((Instance)slInstance)] = 1.0;
        return this.convertDistribution(y, L);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new LC(), args);
    }
}

