/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.Arrays;
import meka.classifiers.multilabel.CCe;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.A;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class PCC
extends CCe
implements TechnicalInformationHandler {
    private boolean push(double[] y, int[] K, int j) {
        if (j >= y.length) {
            return true;
        }
        if (y[j] < (double)(K[j] - 1)) {
            int n = j;
            y[n] = y[n] + 1.0;
            return false;
        }
        y[j] = 0.0;
        return this.push(y, K, ++j);
    }

    private static int[] getKs(Instances D) {
        int L = D.classIndex();
        int[] K = new int[L];
        for (int k = 0; k < L; ++k) {
            K[k] = D.attribute(k).numValues();
        }
        return K;
    }

    @Override
    public double[] distributionForInstance(Instance xy) throws Exception {
        int L = xy.classIndex();
        double[] y = new double[L];
        double w = 0.0;
        int[] K = PCC.getKs(xy.dataset());
        if (this.getDebug()) {
            System.out.println("K[] = " + Arrays.toString(K));
        }
        double[] y_ = new double[L];
        int i = 0;
        for (i = 0; i < 1000000; ++i) {
            double w_ = A.product(super.probabilityForInstance(xy, y_));
            if (w_ > w) {
                if (this.getDebug()) {
                    System.out.println("y' = " + Arrays.toString(y_) + ", :" + w_);
                }
                y = Arrays.copyOf(y_, y_.length);
                w = w_;
            }
            if (this.push(y_, K, 0)) break;
        }
        if (this.getDebug()) {
            System.out.println("Tried all " + (i + 1) + " combinations.");
        }
        return y;
    }

    @Override
    public String globalInfo() {
        return "Probabalistic Classifier Chains. For more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Weiwei Cheng and Krzysztof Dembczynsky and Eyke Hullermeier");
        result.setValue(TechnicalInformation.Field.TITLE, "Bayes Optimal Multi-label Classification via Probabalistic Classifier Chains");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "ICML '10: 27th International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        return result;
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new PCC(), args);
    }
}

