/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.CCe;
import meka.classifiers.multilabel.MCCe;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.A;
import meka.core.MLUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class PMCC
extends MCCe {
    protected int m_M = 0;
    protected int m_O = 0;
    protected double m_Beta = 0.03;
    protected CCe[] h = null;
    protected double[] w = null;

    private static int matchedUpto(String s1, String s2, String DELIM) {
        int i;
        String[] s_1 = s1.split(DELIM);
        String[] s_2 = s2.split(DELIM);
        for (i = 0; i < s_1.length && i < s_2.length && s_1[i].equals(s_2[i]); ++i) {
        }
        return i;
    }

    protected static CCe getClosest(HashMap<String, CCe> map, String sequence) {
        int score = -1;
        String best = sequence;
        for (String key : map.keySet()) {
            int score_ = PMCC.matchedUpto(key, sequence, ",");
            if (score_ <= score) continue;
            score = score_;
            best = key;
        }
        System.out.println("found " + best + " closest to " + sequence);
        return map.get(best);
    }

    protected CCe rebuildCC(CCe h_old, int[] s_new, Instances D) throws Exception {
        CCe h = (CCe)AbstractClassifier.makeCopy((Classifier)h_old);
        h.rebuildClassifier(s_new, new Instances(D));
        return h;
    }

    protected CCe buildCC(int[] s, Instances D) throws Exception {
        CCe h = new CCe();
        h.setChain(s);
        h.setClassifier(this.m_Classifier);
        h.buildClassifier(new Instances(D));
        return h;
    }

    public static int[] pi(int[] s, Random r, int t, double beta) {
        int j;
        int L = s.length;
        System.out.println("--- t = " + t + " , Beta = " + beta + "---");
        double[] p = new double[s.length];
        for (j = 0; j < L; ++j) {
            p[j] = Math.pow(1.0 / (double)L, beta * (double)t / (double)(1 + j));
        }
        Utils.normalize((double[])p);
        j = A.samplePMF(p, r);
        System.out.println("elect j=" + j + " from pmf: " + A.toString(p));
        p[j] = 0.0;
        Utils.normalize((double[])p);
        int k = A.samplePMF(p, r);
        System.out.println("elect k=" + k + " from pmf: " + A.toString(p));
        return A.swap(s, j, k);
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        HashMap<String, CCe> id2cc = new HashMap<String, CCe>();
        this.m_R = new Random(this.m_S);
        int L = D.classIndex();
        int N = D.numInstances();
        int d = D.numAttributes() - L;
        this.h = new CCe[this.m_M];
        this.w = new double[this.m_M];
        if (this.m_Is > 0) {
            int[] s = MLUtils.gen_indices(L);
            MLUtils.randomize(s, this.m_R);
            this.h[0] = this.buildCC(Arrays.copyOf(s, s.length), D);
            this.w[0] = this.payoff(this.h[0], new Instances(D));
            id2cc.put(Arrays.toString(s), this.h[0]);
            if (this.getDebug()) {
                System.out.println("s[0] = " + Arrays.toString(s));
            }
            for (int t = 0; t < this.m_Is; ++t) {
                int[] s_ = this.m_O > 0 ? PMCC.pi(Arrays.copyOf(s, s.length), this.m_R, t, this.m_Beta) : A.swap(Arrays.copyOf(s, s.length), this.m_R);
                CCe h_ = this.rebuildCC(PMCC.getClosest(id2cc, Arrays.toString(s_)), s_, D);
                id2cc.put(Arrays.toString(s_), h_);
                double w_ = this.payoff(h_, new Instances(D));
                int m = Utils.sort((double[])this.w)[0];
                if (!(w_ > this.w[m])) continue;
                this.w[m] = w_;
                this.h[m] = h_;
                if (this.getDebug()) {
                    System.out.println(" accepted h[" + m + "] = " + this.w[m]);
                }
                s = s_;
            }
            if (this.getDebug()) {
                System.out.println("---");
            }
        } else {
            throw new Exception("This classifier must be run with a population. Use MCC if you don't want this.");
        }
        Utils.normalize((double[])this.w);
    }

    public static double[] RandomSearch(CCe[] h, double[] h_weights, Instance x, int T, Random r, double[] y0) throws Exception {
        double[] y = Arrays.copyOf(y0, y0.length);
        double w = A.product(h[0].probabilityForInstance(x, y));
        y = Arrays.copyOf(y, y.length);
        for (int t = 0; t < T; ++t) {
            int m = A.samplePMF(h_weights, r);
            double[] y_ = h[m].sampleForInstance(x, r);
            double w_ = A.product(h[m].getConfidences());
            if (!(w_ > w)) continue;
            w = w_;
            y = y_;
        }
        return y;
    }

    public static double[] RandomSearch(CCe[] h, double[] ww, Instance x, int T, Random r) throws Exception {
        return PMCC.RandomSearch(h, ww, x, T, r, h[0].distributionForInstance(x));
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tThe population size (of chains)\n\tdefault: " + this.m_M, "M", 1, "-M <value>"));
        newVector.addElement(new Option("\tThe option for changing the sequences ~p(.|s)      \n\tdefault: " + this.m_O, "O", 1, "-O <value>"));
        newVector.addElement(new Option("\tIf using O = 1 for temperature, this sets the Beta constant      \n\tdefault: " + this.m_Beta, "B", 1, "-B <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.m_M = Utils.getOptionPos((char)'M', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'M', (String[])options)) : this.m_M;
        this.m_O = Utils.getOptionPos((char)'O', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'O', (String[])options)) : this.m_O;
        this.m_Beta = Utils.getOptionPos((char)'B', (String[])options) >= 0 ? Double.parseDouble(Utils.getOption((char)'B', (String[])options)) : this.m_Beta;
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-M");
        result.add("" + this.m_M);
        result.add("-O");
        result.add("" + this.m_O);
        result.add("-B");
        result.add("" + this.m_Beta);
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new PMCC(), args);
    }
}

