/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.LC;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.LabelSet;
import meka.core.MLUtils;
import meka.core.PSUtils;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class PSe
extends LC
implements Randomizable,
TechnicalInformationHandler {
    private static final long serialVersionUID = 8943667795912487237L;
    protected int m_P = 0;
    protected int m_N = 0;
    protected String m_sP = String.valueOf(this.m_P);
    protected String m_sN = String.valueOf(this.m_N);
    protected int m_S = 1;

    @Override
    public String globalInfo() {
        return "The Pruned Sets method (PS).\nRemoves examples with P-infrequent labelsets from the training data, then subsamples these labelsets N time to produce N new examples with P-frequent labelsets. Then train a standard LC classifier. The idea is to reduce the number of unique class values that would otherwise need to be learned by LC. Best used in an Ensemble (e.g., EnsembleML).\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes");
        result.setValue(TechnicalInformation.Field.TITLE, "Multi-label Classification Using Ensembles of Pruned Sets");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "ICDM'08: International Conference on Data Mining (ICDM 2008). Pisa, Italy.");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        return result;
    }

    private int parseValue(String s) {
        int i = s.indexOf(45);
        Random m_R = new Random(this.m_S);
        if (i > 0 && i < s.length()) {
            int lo = Integer.parseInt(s.substring(0, i));
            int hi = Integer.parseInt(s.substring(i + 1, s.length()));
            return lo + m_R.nextInt(hi - lo + 1);
        }
        return Integer.parseInt(s);
    }

    public int getP() {
        return this.m_P;
    }

    public void setP(int p) {
        this.m_P = p;
    }

    public int getN() {
        return this.m_N;
    }

    public void setN(int n) {
        this.m_N = n;
    }

    public void setSeed(int s) {
        this.m_S = s;
        if (this.m_sP != null) {
            this.m_P = this.parseValue(this.m_sP);
        }
        if (this.m_sN != null) {
            this.m_N = this.parseValue(this.m_sN);
        }
        if (this.getDebug()) {
            System.out.println("P = " + this.m_P);
            System.out.println("N = " + this.m_N);
        }
    }

    public int getSeed() {
        return this.m_S;
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSets the pruning value, defining an infrequent labelset as one which occurs <= P times in the data (P = 0 defaults to LC).\n\tdefault: " + this.m_P + "\t(LC)", "P", 1, "-P <value>"));
        newVector.addElement(new Option("\tSets the (maximum) number of frequent labelsets to subsample from the infrequent labelsets.\n\tdefault: " + this.m_N + "\t(none)\n\tn\tN = n\n\t-n\tN = n, or 0 if LCard(D) >= 2\n\tn-m\tN = random(n,m)", "N", 1, "-N <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        block5: {
            block4: {
                try {
                    this.m_sP = Utils.getOption((char)'P', (String[])options);
                    this.setP(this.parseValue(this.m_sP));
                }
                catch (Exception e) {
                    this.m_sP = String.valueOf(this.getP());
                    if (!this.getDebug()) break block4;
                    System.err.println("Using default P = " + this.getP());
                }
            }
            try {
                this.m_sN = Utils.getOption((char)'N', (String[])options);
                this.setN(this.parseValue(this.m_sN));
            }
            catch (Exception e) {
                this.m_sN = String.valueOf(this.m_N);
                if (!this.getDebug()) break block5;
                System.err.println("Using default N = " + this.getN());
            }
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 4];
        int current = 0;
        options[current++] = "-P";
        options[current++] = "" + this.m_P;
        options[current++] = "-N";
        options[current++] = "" + this.m_N;
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public Instances convertInstances(Instances D, int L) throws Exception {
        HashMap<LabelSet, Integer> distinctCombinations = PSUtils.countCombinationsSparse(D, L);
        MLUtils.pruneCountHashMap(distinctCombinations, this.m_P);
        FastVector ClassValues = new FastVector(L);
        for (LabelSet y : distinctCombinations.keySet()) {
            ClassValues.addElement((Object)y.toString());
        }
        Attribute NewClass = new Attribute("Class", (List)ClassValues);
        Remove FilterRemove = new Remove();
        FilterRemove.setAttributeIndices("1-" + L);
        FilterRemove.setInputFormat(D);
        Instances D_ = Filter.useFilter((Instances)D, (Filter)FilterRemove);
        D_.insertAttributeAt(NewClass, 0);
        D_.setClassIndex(0);
        for (int i = 0; i < D.numInstances(); ++i) {
            LabelSet[] d_subsets;
            Instance x = D.instance(i);
            LabelSet y = new LabelSet(MLUtils.toSparseIntArray(x, L));
            String y_string = y.toString();
            if (ClassValues.contains((Object)y_string)) {
                D_.instance(i).setClassValue(y_string);
                continue;
            }
            if (this.m_N <= 0) continue;
            for (LabelSet s : d_subsets = PSUtils.getTopNSubsets(y, distinctCombinations, this.m_N)) {
                Instance x_ = (Instance)D_.instance(i).copy();
                x_.setClassValue(s.toString());
                D_.add(x_);
            }
        }
        D_.deleteWithMissingClass();
        this.m_InstancesTemplate = new Instances(D_, 0);
        return D_;
    }

    private static final double[] toDoubleArray(String labelSet, int L) {
        int[] set = labelSet.length() <= 2 ? new int[]{} : MLUtils.toIntArray(labelSet);
        double[] y = new double[L];
        for (int j : set) {
            y[j] = 1.0;
        }
        return y;
    }

    @Override
    public double[] convertDistribution(double[] p, int L) {
        double[] y = new double[L];
        int i = Utils.maxIndex((double[])p);
        double[] d = PSe.toDoubleArray(this.m_InstancesTemplate.classAttribute().value(i), L);
        for (int j = 0; j < d.length; ++j) {
            if (!(d[j] > 0.0)) continue;
            y[j] = 1.0;
        }
        return y;
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        if (this.m_N < 0) {
            double lc = MLUtils.labelCardinality(D, L);
            this.m_N = lc > 2.0 ? 0 : Math.abs(this.m_N);
            this.m_sN = String.valueOf(this.m_N);
            System.err.println("N set to " + this.m_N);
        }
        Instances D_ = this.convertInstances(D, L);
        if (this.getDebug()) {
            System.out.println("(" + this.m_InstancesTemplate.attribute(0).numValues() + " classes, " + D_.numInstances() + " ins. )");
        }
        this.m_Classifier.buildClassifier(D_);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new PSe(), args);
    }
}

