/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.List;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.MLUtils;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class RT
extends MultilabelClassifier {
    private static final long serialVersionUID = 7348139531854838421L;

    @Override
    public String globalInfo() {
        return "Duplicate each multi-labelled example, assigning one of the labels to each copy. Train a regular multi-class base classifier.\nUse the multi-class classifier as a multi-label classifier by Ranking outputs and using a Threshold to separate relevant from irrelevant labels.\nUse a multi-class classifier as a multi-label classifier by 'Ranking' outputs and using a 'Threshold'.\nSee also MULAN framework:\nhttp://mulan.sourceforge.net";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        Instances D_ = new Instances(D, 0, 0);
        for (int j = 0; j < L; ++j) {
            D_.deleteAttributeAt(0);
        }
        FastVector classes = new FastVector(L);
        for (int j = 0; j < L; ++j) {
            classes.addElement((Object)MLUtils.toBitString(j, L));
        }
        D_.insertAttributeAt(new Attribute("ClassY", (List)classes), 0);
        D_.setClassIndex(0);
        for (int i = 0; i < D.numInstances(); ++i) {
            for (int j = 0; j < L; ++j) {
                if ((int)D.instance(i).value(j) <= 0) continue;
                Instance inew = (Instance)D.instance(i).copy();
                inew.setDataset(null);
                for (int k = 1; k < L; ++k) {
                    inew.deleteAttributeAt(1);
                }
                inew.setDataset(D_);
                inew.setClassValue((double)j);
                D_.add(inew);
            }
        }
        this.m_InstancesTemplate = new Instances(D_, 0);
        if (this.getDebug()) {
            System.out.println("Building classifier " + this.m_Classifier.getClass().getName() + " with " + D_.numInstances() + " instances");
        }
        this.m_Classifier.buildClassifier(D_);
    }

    public Instance convertInstance(Instance test) {
        int L = test.classIndex();
        Instance real = (Instance)test.copy();
        real.setDataset(null);
        for (int i = 0; i < L; ++i) {
            real.deleteAttributeAt(0);
        }
        real.insertAttributeAt(0);
        real.setDataset(this.m_InstancesTemplate);
        return real;
    }

    @Override
    public double[] distributionForInstance(Instance test) throws Exception {
        return this.m_Classifier.distributionForInstance(this.convertInstance(test));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new RT(), args);
    }
}

