/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.cc;

import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import meka.core.A;
import meka.core.F;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.SMO;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;

public class CNode
implements Serializable {
    private int j = -1;
    private int d = -1;
    private int[] inX = null;
    private int[] paY = null;
    private Instances T = null;
    private Instance t_ = null;
    private Classifier h = null;
    private int[] map = null;

    public CNode(int j, int[] inX, int[] paY) {
        this.j = j;
        this.inX = inX;
        this.paY = paY;
    }

    public int[] getParentsY() {
        return this.paY;
    }

    public Instances transform(Instances D) throws Exception {
        int L = D.classIndex();
        this.d = D.numAttributes() - L;
        int[] keep = A.append(this.paY, this.j);
        Arrays.sort(keep);
        int[] remv = CNode.complement(keep, L);
        Arrays.sort(remv);
        this.map = new int[L];
        for (int j = 0; j < L; ++j) {
            this.map[j] = Arrays.binarySearch(keep, j);
        }
        Instances D_ = F.remove(new Instances(D), remv, false);
        D_.setClassIndex(this.map[this.j]);
        return D_;
    }

    public void build(Instances D, Classifier H) throws Exception {
        this.T = this.transform(D);
        this.h = AbstractClassifier.makeCopy((Classifier)H);
        this.h.buildClassifier(this.T);
        this.t_ = new SparseInstance(this.T.numAttributes());
        this.t_.setDataset(this.T);
        this.t_.setClassMissing();
        this.T.clear();
    }

    public double[] distribution(Instance x, double[] ypred) throws Exception {
        Instance x_ = this.transform(x, ypred);
        return this.h.distributionForInstance(x_);
    }

    public double sample(Instance x, double[] ypred, Random r) throws Exception {
        double[] p = this.distribution(x, ypred);
        return A.samplePMF(p, r);
    }

    public Instance transform(Instance x, double[] ypred) throws Exception {
        int L = x.classIndex();
        double[] array = x.toDoubleArray();
        double[] array_ = new double[this.d + this.paY.length + 1];
        for (int pa : this.paY) {
            array_[this.map[pa]] = ypred[pa];
        }
        System.arraycopy(array, L, array_, this.paY.length + 1, this.d);
        SparseInstance x_ = new SparseInstance(1.0, array_);
        x_.setDataset(this.T);
        x_.setClassMissing();
        return x_;
    }

    public double classify(Instance x, double[] ypred) throws Exception {
        Instance x_ = this.transform(x, ypred);
        return Utils.maxIndex((double[])this.h.distributionForInstance(x_));
    }

    public static Instances transform(Instances D, int c, int[] pa_c) throws Exception {
        int L = D.classIndex();
        int[] keep = A.append(pa_c, c);
        Arrays.sort(keep);
        int[] remv = CNode.complement(keep, L);
        Arrays.sort(remv);
        Instances T = F.remove(new Instances(D), remv, false);
        int[] map = new int[L];
        for (int j = 0; j < L; ++j) {
            map[j] = Arrays.binarySearch(keep, j);
        }
        T.setClassIndex(map[c]);
        return T;
    }

    private static final int[] complement(int[] indices, int L) {
        int[] sindices = Arrays.copyOf(indices, indices.length);
        Arrays.sort(sindices);
        int[] inverted = new int[L - sindices.length];
        int i = 0;
        for (int j = 0; j < L; ++j) {
            if (Arrays.binarySearch(sindices, j) >= 0) continue;
            inverted[i++] = j;
        }
        return inverted;
    }

    public static void main(String[] args) throws Exception {
        Instances D = new Instances((Reader)new FileReader(args[0]));
        Instance x = D.lastInstance();
        D.remove(D.numInstances() - 1);
        int L = Integer.parseInt(args[1]);
        D.setClassIndex(L);
        double[] y = new double[L];
        Random r = new Random();
        int[] s = new int[]{1, 0, 2};
        int[][] PA_J = new int[][]{new int[0], new int[0], {0, 1}};
        for (int j : s) {
            int[] pa_j = PA_J[j];
            System.out.println("PARENTS = " + Arrays.toString(pa_j));
            System.out.println("**** TRAINING ***");
            CNode n = new CNode(j, null, pa_j);
            n.build(D, (Classifier)new SMO());
            System.out.println("============== D_" + j + " / class = " + n.T.classIndex() + " =");
            System.out.println("" + n.T);
            System.out.println("**** TESTING ****");
            Instance x_ = n.transform(x, y);
            System.out.println("" + x_);
            y[j] = 1.0;
        }
    }
}

