/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.Random;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.meta.MultilabelMetaClassifier;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.RevisionUtils;

public class EnsembleML
extends MultilabelMetaClassifier {
    private static final long serialVersionUID = 835659467275068411L;

    @Override
    public String globalInfo() {
        return "Combining several multi-label classifiers in a simple-subset ensemble.";
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.testCapabilities(train);
        if (this.getDebug()) {
            System.out.print("-: Models: ");
        }
        train = new Instances(train);
        this.m_Classifiers = MultilabelClassifier.makeCopies((MultilabelClassifier)this.m_Classifier, this.m_NumIterations);
        int sub_size = train.numInstances() * this.m_BagSizePercent / 100;
        for (int i = 0; i < this.m_NumIterations; ++i) {
            if (this.getDebug()) {
                System.out.print("" + i + " ");
            }
            if (this.m_Classifiers[i] instanceof Randomizable) {
                ((Randomizable)this.m_Classifiers[i]).setSeed(i);
            }
            train.randomize(new Random(this.m_Seed + i));
            Instances sub_train = new Instances(train, 0, sub_size);
            this.m_Classifiers[i].buildClassifier(sub_train);
        }
        if (this.getDebug()) {
            System.out.println(":-");
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new EnsembleML(), args);
    }
}

