/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.List;
import meka.classifiers.multilabel.BR;
import meka.classifiers.multilabel.MultilabelClassifier;
import weka.classifiers.AbstractClassifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class MBR
extends MultilabelClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 865889198021748917L;
    protected BR m_BASE = null;
    protected BR m_META = null;

    @Override
    public String globalInfo() {
        return "BR stacked with feature outputs.\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Shantanu Godbole, Sunita Sarawagi");
        result.setValue(TechnicalInformation.Field.TITLE, "Discriminative Methods for Multi-labeled Classification");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Knowledge Discovery and Data Mining");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.PAGES, "22-30");
        result.setValue(TechnicalInformation.Field.SERIES, "LNCS");
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int i;
        this.testCapabilities(data);
        int c = data.classIndex();
        if (this.getDebug()) {
            System.out.println(" Build BR Base (" + c + " models)");
        }
        this.m_BASE = (BR)AbstractClassifier.forName((String)this.getClassifier().getClass().getName(), (String[])((AbstractClassifier)this.getClassifier()).getOptions());
        this.m_BASE.buildClassifier(data);
        if (this.getDebug()) {
            System.out.println(" Prepare Meta data           ");
        }
        Instances meta_data = new Instances(data);
        FastVector BinaryClass = new FastVector(c);
        BinaryClass.addElement((Object)"0");
        BinaryClass.addElement((Object)"1");
        for (i = 0; i < c; ++i) {
            meta_data.insertAttributeAt(new Attribute("metaclass" + i, (List)BinaryClass), c);
        }
        for (i = 0; i < data.numInstances(); ++i) {
            double[] cfn = this.m_BASE.distributionForInstance(data.instance(i));
            for (int a = 0; a < cfn.length; ++a) {
                meta_data.instance(i).setValue(a + c, cfn[a]);
            }
        }
        meta_data.setClassIndex(c);
        this.m_InstancesTemplate = new Instances(meta_data, 0);
        if (this.getDebug()) {
            System.out.println(" Build BR Meta (" + c + " models)");
        }
        this.m_META = (BR)AbstractClassifier.forName((String)this.getClassifier().getClass().getName(), (String[])((AbstractClassifier)this.getClassifier()).getOptions());
        this.m_META.buildClassifier(meta_data);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int i;
        int c = instance.classIndex();
        double[] result = this.m_BASE.distributionForInstance(instance);
        instance.setDataset(null);
        for (i = 0; i < c; ++i) {
            instance.insertAttributeAt(c);
        }
        instance.setDataset(this.m_InstancesTemplate);
        for (i = 0; i < c; ++i) {
            instance.setValue(c + i, result[i]);
        }
        return this.m_META.distributionForInstance(instance);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new MBR(), args);
    }
}

