/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.Enumeration;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import weka.core.Instance;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.Utils;

public abstract class MultilabelMetaClassifier
extends MultilabelClassifier
implements Randomizable {
    private static final long serialVersionUID = -6604797895790690612L;
    protected MultilabelClassifier[] m_Classifiers = null;
    protected int m_Seed = 1;
    protected int m_NumIterations = 10;
    protected int m_BagSizePercent = 67;

    @Override
    public String globalInfo() {
        return "For ensembles of multi-label methods.";
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] r = new double[instance.classIndex()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            double[] d = this.m_Classifiers[i].distributionForInstance(instance);
            for (int j = 0; j < d.length; ++j) {
                int n = j;
                r[n] = r[n] + d[j];
            }
        }
        for (int j = 0; j < r.length; ++j) {
            r[j] = r[j] / (double)this.m_NumIterations;
        }
        return r;
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public void setNumIterations(int n) {
        this.m_NumIterations = n;
    }

    public int getBagSizePercent() {
        return this.m_BagSizePercent;
    }

    public void setBagSizePercent(int p) {
        this.m_BagSizePercent = p;
    }

    public void setSeed(int s) {
        this.m_Seed = s;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\t@Sets the number of models (default " + this.m_NumIterations + ")", "I", 1, "-I <num>"));
        newVector.addElement(new Option("\t@Size of each bag, as a percentage of total training size (default " + this.m_BagSizePercent + ")", "P", 1, "-P <size percentage>"));
        newVector.addElement(new Option("\t@Random number seed for sampling (default " + this.m_Seed + ")", "S", 1, "-S <seed>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        try {
            this.m_Seed = Integer.parseInt(Utils.getOption((char)'S', (String[])options));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_NumIterations = Integer.parseInt(Utils.getOption((char)'I', (String[])options));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_BagSizePercent = Integer.parseInt(Utils.getOption((char)'P', (String[])options));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 6];
        int current = 0;
        options[current++] = "-S";
        options[current++] = String.valueOf(this.m_Seed);
        options[current++] = "-I";
        options[current++] = String.valueOf(this.m_NumIterations);
        options[current++] = "-P";
        options[current++] = String.valueOf(this.m_BagSizePercent);
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }
}

