/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.meta.MultilabelMetaClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RandomSubspaceML
extends MultilabelMetaClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 3608541911971484299L;
    protected int m_AttSizePercent = 50;
    protected ArrayList[] m_Indices = null;
    protected Instances[] m_Dsets = null;

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.testCapabilities(train);
        this.m_Indices = new ArrayList[this.m_NumIterations];
        this.m_Dsets = new Instances[this.m_NumIterations];
        if (this.getDebug()) {
            System.out.print("-: Models: ");
        }
        this.m_Classifiers = MultilabelClassifier.makeCopies((MultilabelClassifier)this.m_Classifier, this.m_NumIterations);
        for (int i = 0; i < this.m_NumIterations; ++i) {
            int j;
            Instances bag;
            Random r = new Random(this.m_Seed + i);
            this.m_Indices[i] = new ArrayList();
            Instances trainCut = new Instances(train);
            trainCut.setClassIndex(-1);
            double d = (double)this.m_AttSizePercent / 100.0;
            for (int a = trainCut.numAttributes() - 1; a >= train.classIndex(); --a) {
                if (!(r.nextDouble() > d) || this.m_Indices[i].contains(a)) continue;
                this.m_Indices[i].add(a);
            }
            for (Object a : this.m_Indices[i]) {
                trainCut.deleteAttributeAt(((Integer)a).intValue());
            }
            this.m_Dsets[i] = bag = new Instances(trainCut, 0);
            if (this.m_Classifiers[i] instanceof Randomizable) {
                ((Randomizable)this.m_Classifiers[i]).setSeed(this.m_Seed + i);
            }
            if (this.getDebug()) {
                System.out.print("" + i + " ");
            }
            int[] ixs = new int[trainCut.numInstances()];
            for (j = 0; j < ixs.length; ++j) {
                int n = r.nextInt(ixs.length);
                ixs[n] = ixs[n] + 1;
            }
            for (j = 0; j < ixs.length; ++j) {
                if (ixs[j] <= 0) continue;
                Instance instance = trainCut.instance(j);
                instance.setWeight((double)ixs[j]);
                bag.add(instance);
            }
            bag.setClassIndex(train.classIndex());
            this.m_Classifiers[i].buildClassifier(bag);
        }
        if (this.getDebug()) {
            System.out.println(":-");
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] r = new double[instance.classIndex()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            Instance copy = (Instance)instance.copy();
            copy.setDataset(null);
            for (Object a : this.m_Indices[i]) {
                copy.deleteAttributeAt(((Integer)a).intValue());
            }
            copy.setDataset(this.m_Dsets[i]);
            double[] d = this.m_Classifiers[i].distributionForInstance(copy);
            for (int j = 0; j < d.length; ++j) {
                int n = j;
                r[n] = r[n] + d[j];
            }
        }
        return r;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\t@Size of attribute space, as a percentage of total attribute space size (default " + this.m_AttSizePercent + ")", "A", 1, "-A <size percentage>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        try {
            this.m_AttSizePercent = Integer.parseInt(Utils.getOption((char)'A', (String[])options));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 2];
        int current = 0;
        options[current++] = "-A";
        options[current++] = String.valueOf(this.m_BagSizePercent);
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new RandomSubspaceML(), args);
    }

    @Override
    public String globalInfo() {
        return "Combining several multi-label classifiers in an ensemble where the attribute space for each model is a random subset of the original space.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Bernhard Pfahringer, Geoff Holmes, Eibe Frank");
        result.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning Journal");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.VOLUME, "85");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.PAGES, "333-359");
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public void setAttSizePercent(int value) {
        if (value > 0 && value <= 100) {
            this.m_AttSizePercent = value;
        } else {
            System.err.println("Bad percentage (must be between 1 and 100");
        }
    }

    public int getAttSizePercent() {
        return this.m_AttSizePercent;
    }

    public String attSizePercentTipText() {
        return "Size of attribute space, as a percentage of total attribute space size";
    }
}

