/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.Arrays;
import java.util.Random;
import meka.classifiers.multilabel.CCe;
import meka.core.A;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public abstract class CCUtils {
    public static CCe buildCC(int[] chain, Instances D, Classifier g) throws Exception {
        CCe h = new CCe();
        h.setChain(chain);
        h.setClassifier(g);
        h.buildClassifier(new Instances(D));
        return h;
    }

    public static double[] RandomSearch(CCe h, Instance x, int T, Random r, double[] y0) throws Exception {
        double[] y = Arrays.copyOf(y0, y0.length);
        double w = A.product(h.probabilityForInstance(x, y));
        y = Arrays.copyOf(y, y.length);
        for (int t = 0; t < T; ++t) {
            double[] y_ = h.sampleForInstance(x, r);
            double w_ = A.product(h.getConfidences());
            if (!(w_ > w)) continue;
            w = w_;
            y = y_;
        }
        return y;
    }

    public static double[] RandomSearch(CCe h, Instance x, int T, Random r) throws Exception {
        return CCUtils.RandomSearch(h, x, T, r, h.distributionForInstance(x));
    }

    public static void setPath(Instance xy, double[] path) {
        int L = xy.classIndex();
        for (int j = 0; j < L; ++j) {
            xy.setValue(j, (double)((int)Math.round(path[j])));
        }
    }

    public static Instances linkTransform(Instances D, int j, int idx, int[] exl) {
        Instances D_j = new Instances(D);
        D_j.setClassIndex(-1);
        int ndx = idx;
        for (int i = exl.length - 1; i >= 0; --i) {
            D_j.deleteAttributeAt(exl[i]);
            if (exl[i] >= ndx) continue;
            --ndx;
        }
        D_j.setClassIndex(ndx);
        return D_j;
    }

    public static Instance linkTransformation(Instance x, int[] excl, Instances _template) {
        Instance copy = (Instance)x.copy();
        copy.setDataset(null);
        for (int i = excl.length - 1; i >= 0; --i) {
            copy.deleteAttributeAt(excl[i]);
        }
        copy.setDataset(_template);
        return copy;
    }
}

