/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import meka.core.MLUtils;
import meka.core.Metrics;
import meka.core.Result;
import meka.core.ThresholdUtils;
import weka.core.Instances;
import weka.core.Utils;

public abstract class MLEvalUtils {
    public static String getThreshold(ArrayList<double[]> Y, Instances D, String top) throws Exception {
        if (top.equals("PCut1") || top.equals("c")) {
            return String.valueOf(ThresholdUtils.calibrateThreshold(Y, MLUtils.labelCardinality(D)));
        }
        if (top.equals("PCutL") || top.equals("C")) {
            return Arrays.toString(ThresholdUtils.calibrateThresholds(Y, MLUtils.labelCardinalities(D)));
        }
        return top;
    }

    public static HashMap<String, Double> getMLStats(double[][] Rpred, int[][] Y, String t, String vop) {
        double[] ts = ThresholdUtils.thresholdStringToArray(t, Y[0].length);
        return MLEvalUtils.getMLStats(Rpred, Y, ts, vop);
    }

    public static HashMap<String, Double> getMLStats(double[][] Rpred, int[][] Y, double[] t, String vop) {
        int N = Y.length;
        int L = Y[0].length;
        int V = MLUtils.getIntegerOption(vop, 1);
        int[][] Ypred = ThresholdUtils.threshold(Rpred, t);
        LinkedHashMap<String, Double> results = new LinkedHashMap<String, Double>();
        results.put("L", Double.valueOf(L));
        results.put("Accuracy", Metrics.P_Accuracy(Y, Ypred));
        results.put("Hamming score", Metrics.P_Hamming(Y, Ypred));
        results.put("Exact match", Metrics.P_ExactMatch(Y, Ypred));
        if (V > 1) {
            int j;
            results.put("Jaccard dist", Metrics.L_JaccardDist(Y, Ypred));
            results.put("Hamming loss", Metrics.L_Hamming(Y, Ypred));
            results.put("ZeroOne loss", Metrics.L_ZeroOne(Y, Ypred));
            results.put("Harmonic score", Metrics.P_Harmonic(Y, Ypred));
            results.put("One error", Metrics.L_OneError(Y, Rpred));
            results.put("Rank loss", Metrics.L_RankLoss(Y, Rpred));
            results.put("Avg precision", Metrics.P_AveragePrecision(Y, Rpred));
            results.put("Log Loss D", Metrics.L_LogLossD(Y, Rpred));
            results.put("Log Loss L", Metrics.L_LogLossL(Y, Rpred));
            results.put("F-micro", Metrics.P_FmicroAvg(Y, Ypred));
            results.put("F-macro_D", Metrics.P_FmacroAvgD(Y, Ypred));
            results.put("F-macro_L", Metrics.P_FmacroAvgL(Y, Ypred));
            results.put("N_empty", MLUtils.emptyVectors(Ypred));
            if (V > 2) {
                for (j = 0; j < L; ++j) {
                    results.put("Accuracy[" + j + "]", Metrics.P_Hamming(Y, Ypred, j));
                    results.put("Harmonic[" + j + "]", Metrics.P_Harmonic(Y, Ypred, j));
                    if (V <= 3) continue;
                    results.put("Precision[" + j + "]", Metrics.P_Precision(Y, Ypred, j));
                    results.put("Recall[" + j + "]", Metrics.P_Recall(Y, Ypred, j));
                }
            }
            results.put("LCard_pred", MLUtils.labelCardinality(Ypred));
            if (V > 4) {
                for (j = 0; j < L; ++j) {
                    results.put("LCard[" + j + "]", Metrics.P_Hamming(Y, Ypred, j));
                }
            }
        }
        return results;
    }

    public static HashMap<String, Double> getMTStats(double[][] Rpred, int[][] Y, String vop) {
        int[][] Ypred = ThresholdUtils.round(Rpred);
        int N = Y.length;
        int L = Y[0].length;
        int V = MLUtils.getIntegerOption(vop, 1);
        LinkedHashMap<String, Double> output = new LinkedHashMap<String, Double>();
        output.put("N", Double.valueOf(N));
        output.put("L", Double.valueOf(L));
        output.put("Hamming loss", Metrics.L_Hamming(Y, Ypred));
        output.put("ZeroOne loss", Metrics.L_ZeroOne(Y, Ypred));
        output.put("Hamming score", Metrics.P_Hamming(Y, Ypred));
        output.put("Exact match", Metrics.P_ExactMatch(Y, Ypred));
        if (V > 2) {
            for (int j = 0; j < L; ++j) {
                output.put("L" + j + "_acc", 1.0 - Metrics.P_Hamming(Y, Ypred, j));
            }
        }
        return output;
    }

    public static Result averageResults(Result[] folds) {
        String avg_sd;
        double[] values;
        Result r = new Result();
        r.info = folds[0].info;
        for (String metric : folds[0].output.keySet()) {
            values = new double[folds.length];
            for (int i = 0; i < folds.length; ++i) {
                values[i] = folds[i].output.get(metric);
            }
            avg_sd = Utils.doubleToString((double)Utils.mean((double[])values), (int)5, (int)3) + " +/- " + Utils.doubleToString((double)Math.sqrt(Utils.variance((double[])values)), (int)5, (int)3);
            r.setInfo(metric, avg_sd);
        }
        for (String metric : folds[0].vals.keySet()) {
            values = new double[folds.length];
            for (int i = 0; i < folds.length; ++i) {
                values[i] = folds[i].vals.get(metric);
            }
            avg_sd = Utils.doubleToString((double)Utils.mean((double[])values), (int)5, (int)3) + " +/- " + Utils.doubleToString((double)Math.sqrt(Utils.variance((double[])values)), (int)5, (int)3);
            r.setInfo(metric, avg_sd);
        }
        r.setInfo("Type", "CV");
        return r;
    }

    public static void main(String[] args) {
    }
}

