/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import meka.core.LabelSet;
import meka.core.LabelSetComparator;
import meka.core.MLUtils;
import weka.core.Instances;
import weka.core.Utils;

public abstract class PSUtils {
    public static int sumCounts(HashMap<LabelSet, Integer> map) {
        int c = 0;
        for (Integer c_ : map.values()) {
            c += c_.intValue();
        }
        return c;
    }

    public static int countSubsets(LabelSet ysub, Set<LabelSet> Y) {
        int c = 0;
        for (LabelSet s : Y) {
            if (ysub.subsetof(s) <= 0) continue;
            ++c;
        }
        return c;
    }

    public static Set<LabelSet> getSubsets(LabelSet y, Set<LabelSet> set) {
        HashSet<LabelSet> subsets = new HashSet<LabelSet>();
        for (LabelSet s : set) {
            int m = LabelSet.subset(s.indices, y.indices);
            if (m <= 0) continue;
            subsets.add(s);
        }
        return subsets;
    }

    public static SortedSet<LabelSet> getSortedSubsets(LabelSet y, Set<LabelSet> set, Comparator cmp) {
        TreeSet<LabelSet> subsets = new TreeSet<LabelSet>(cmp);
        for (LabelSet s : set) {
            int m = LabelSet.subset(s.indices, y.indices);
            if (m <= 0) continue;
            subsets.add(s);
        }
        return subsets;
    }

    public static SortedSet<LabelSet> getSortedSubsets(LabelSet y, HashMap<LabelSet, Integer> map) {
        return PSUtils.getSortedSubsets(y, map.keySet(), new LabelSetComparator(map));
    }

    public static LabelSet[] cover(LabelSet y, HashMap<LabelSet, Integer> map) {
        Integer count = map.get(y);
        if (count != null && count >= 1) {
            return new LabelSet[]{y};
        }
        LabelSetComparator cmp = new LabelSetComparator(map);
        SortedSet<LabelSet> allS = PSUtils.getSortedSubsets(y, map.keySet(), cmp);
        Set<LabelSet> covS = PSUtils.cover(y, allS, cmp);
        return covS.toArray(new LabelSet[0]);
    }

    public static Set<LabelSet> cover(LabelSet y, SortedSet<LabelSet> S, Comparator cmp) {
        LabelSet y_copy = y.deep_copy();
        HashSet<LabelSet> K = new HashSet<LabelSet>();
        while (S.size() > 0 && y_copy.indices.length > 0) {
            LabelSet s_ = S.last();
            K.add(s_);
            y_copy.minus(s_);
            S = PSUtils.getSortedSubsets(y_copy, S, cmp);
        }
        return K;
    }

    public static LabelSet[] getAllSubsets(LabelSet y, HashMap<LabelSet, Integer> map) {
        Integer count = map.get(y);
        if (count != null && count >= 1) {
            return new LabelSet[]{y};
        }
        SortedSet<LabelSet> subsets = PSUtils.getSortedSubsets(y, map.keySet(), new LabelSetComparator(map));
        LabelSet[] s = subsets.toArray(new LabelSet[subsets.size()]);
        return s;
    }

    public static LabelSet[] getTopNSubsets(LabelSet y, HashMap<LabelSet, Integer> map, int n) {
        LabelSet[] s = PSUtils.getAllSubsets(y, map);
        return Arrays.copyOfRange(s, Math.max(0, s.length - n), s.length);
    }

    public static SortedSet<LabelSet> getTopNSubsetsAsSet(LabelSet y, HashMap<LabelSet, Integer> map, int n) {
        SortedSet<LabelSet> allSets = PSUtils.getSortedSubsets(y, map);
        TreeSet<LabelSet> topSets = new TreeSet<LabelSet>();
        int n_ = 0;
        for (LabelSet Y : allSets) {
            topSets.add(Y);
            if (++n_ <= n) continue;
            break;
        }
        return topSets;
    }

    public static LabelSet getTopSubset(LabelSet y, HashMap<LabelSet, Integer> map) {
        return PSUtils.getTopNSubsets(y, map, 1)[0];
    }

    public static HashMap<LabelSet, Integer> countCombinationsSparseSubset(Instances D, int[] indices) {
        HashMap<LabelSet, Integer> map = new HashMap<LabelSet, Integer>();
        for (int i = 0; i < D.numInstances(); ++i) {
            LabelSet m;
            map.put(m, map.containsKey(m = new LabelSet(MLUtils.toSubIndicesSet(D.instance(i), indices))) ? map.get(m) + 1 : 1);
        }
        return map;
    }

    public static final HashMap<LabelSet, Integer> countCombinationsSparse(Instances D, int L) {
        HashMap<LabelSet, Integer> map = new HashMap<LabelSet, Integer>();
        for (int i = 0; i < D.numInstances(); ++i) {
            LabelSet y;
            Integer c = map.get(y = new LabelSet(MLUtils.toSparseIntArray(D.instance(i), L)));
            map.put(y, c == null ? 1 : c + 1);
        }
        return map;
    }

    public static double[] convertDistribution(double[] p, int L, LabelSet[] meta_labels) {
        double[] y = new double[L];
        for (int i = 0; i < p.length; ++i) {
            LabelSet Y_i = meta_labels[i];
            int[] arr$ = Y_i.indices;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int j;
                int n = j = arr$[i$];
                y[n] = y[n] + p[i];
            }
        }
        return y;
    }

    public static final LabelSet[] makeLabelSetMap(Instances T) {
        int L_ = 4;
        return new LabelSet[L_];
    }

    public static final double[] recombination(double[] p, int L, LabelSet[] map) {
        double[] y = new double[L];
        int i = Utils.maxIndex((double[])p);
        LabelSet y_meta = map[i];
        for (int j : y_meta.indices) {
            y[j] = 1.0;
        }
        return y;
    }

    public static final double[] recombination_t(double[] p, int L, LabelSet[] map) {
        double[] y = new double[L];
        for (int i = 0; i < p.length; ++i) {
            LabelSet y_meta = map[i];
            int[] arr$ = y_meta.indices;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int j;
                int n = j = arr$[i$];
                y[n] = y[n] + p[i];
            }
        }
        return y;
    }

    public static final LabelSet[] convert(LabelSet[] sparseY, HashMap<LabelSet, Integer> map) {
        return null;
    }

    public static final void saveMap(String filename, HashMap<LabelSet, Integer> map) throws Exception {
        MLUtils.saveObject(map, filename);
    }

    public static HashMap<LabelSet, Integer> loadMap(String filename) throws Exception {
        return (HashMap)MLUtils.loadObject(filename);
    }
}

