/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.HashMap;
import java.util.Random;
import meka.classifiers.multilabel.BR;
import meka.classifiers.multilabel.Evaluation;
import meka.core.A;
import meka.core.LabelSet;
import meka.core.M;
import meka.core.MLUtils;
import meka.core.Metrics;
import meka.core.Result;
import meka.core.ThresholdUtils;
import weka.classifiers.Classifier;
import weka.classifiers.functions.SMO;
import weka.core.Instance;
import weka.core.Instances;

public abstract class StatUtils {
    public static final double[] CRITICAL = new double[]{0.0, 2.706, 4.605, 6.251, 7.779};

    public static double[] P(double[][] Y, int[] x) {
        int L = x.length;
        return StatUtils.P(Y, MLUtils.gen_indices(L), x);
    }

    public static double[] P(double[][] Y, int[] j, int[] x) {
        int L = j.length;
        double[] p = new double[L];
        for (int j_ = 0; j_ < L; ++j_) {
            p[j_] = StatUtils.p(Y, j[j_], x[j_]);
        }
        return p;
    }

    public static double p(double[][] Y, int j, int k) {
        int N = Y.length;
        double p = 1.0E-4;
        for (int i = 0; i < N; ++i) {
            if ((int)Math.round(Y[i][j]) != k) continue;
            p += 1.0;
        }
        return p / (double)N;
    }

    public static double p(Instances D, int j, int j_) {
        return StatUtils.p(MLUtils.getYfromD(D), j, j_);
    }

    public static double P(double[][] Y, int j, int v, int k, int w) {
        int N = Y.length;
        double p = 1.0E-4;
        for (int i = 0; i < N; ++i) {
            if ((int)Math.round(Y[i][j]) != v || (int)Math.round(Y[i][k]) != w) continue;
            p += 1.0;
        }
        return p / (double)N;
    }

    public static double P(Instances D, int j, int v, int k, int w) {
        return StatUtils.P(MLUtils.getYfromD(D), j, v, k, w);
    }

    private static boolean match(Instance x, int[] indices, int[] values) {
        for (int j = 0; j < indices.length; ++j) {
            int v = (int)Math.round(x.value(indices[j]));
            if (v == values[j]) continue;
            return false;
        }
        return true;
    }

    public static double P(Instances D, int[] j, int[] v) {
        int N = D.numInstances();
        int n = 0;
        for (Instance x : D) {
            if (!StatUtils.match(x, j, v)) continue;
            ++n;
        }
        return Math.max(1.0E-4, (double)n / (double)N);
    }

    public static double[][] jPMF(Instances D, int j, int k) {
        double[][] JOINT = new double[D.attribute(j).numValues()][D.attribute(k).numValues()];
        int N = D.numInstances();
        for (int i = 0; i < N; ++i) {
            int v_j = (int)Math.round(D.instance(i).value(j));
            int v_k = (int)Math.round(D.instance(i).value(k));
            double[] dArray = JOINT[v_j];
            int n = v_k;
            dArray[n] = dArray[n] + 1.0 / (double)N;
        }
        return JOINT;
    }

    public static double[][][] jPMF(Instances D, int j, int k, int l) {
        double[][][] JOINT = new double[D.attribute(j).numValues()][D.attribute(k).numValues()][D.attribute(l).numValues()];
        int N = D.numInstances();
        for (int i = 0; i < N; ++i) {
            int v_j = (int)Math.round(D.instance(i).value(j));
            int v_k = (int)Math.round(D.instance(i).value(k));
            int v_l = (int)Math.round(D.instance(i).value(l));
            double[] dArray = JOINT[v_j][v_k];
            int n = v_l;
            dArray[n] = dArray[n] + 1.0 / (double)N;
        }
        return JOINT;
    }

    public static double[][] getP(Instances D) {
        double N = D.numInstances();
        int L = D.classIndex();
        double[][] P = new double[L][L];
        for (int j = 0; j < L; ++j) {
            P[j][j] = StatUtils.p(D, j, 1);
            for (int k = j + 1; k < L; ++k) {
                P[j][k] = StatUtils.P(D, j, 1, k, 1);
            }
        }
        return P;
    }

    public static int[][] getApproxC(Instances D) {
        int N = D.numInstances();
        int L = D.classIndex();
        int[][] C = new int[L][L];
        HashMap<LabelSet, Integer> map = MLUtils.countCombinationsSparse(D, L);
        for (LabelSet y : map.keySet()) {
            int c = map.get(y);
            for (int j = 0; j < y.indices.length; ++j) {
                int j_ = y.indices[j];
                int[] nArray = C[j_];
                int n = j_;
                nArray[n] = nArray[n] + c;
                for (int k = j + 1; k < y.indices.length; ++k) {
                    int k_ = y.indices[k];
                    int[] nArray2 = C[j_];
                    int n2 = k_;
                    nArray2[n2] = nArray2[n2] + c;
                }
            }
        }
        return C;
    }

    public static double[][] getApproxP(Instances D) {
        int N = D.numInstances();
        int L = D.classIndex();
        double[][] P = new double[L][L];
        HashMap<LabelSet, Integer> map = MLUtils.countCombinationsSparse(D, L);
        for (LabelSet y : map.keySet()) {
            for (int j = 0; j < y.indices.length; ++j) {
                int y_j;
                int n = y_j = y.contains(j) ? 1 : 0;
                if (y_j <= 0) continue;
                double[] dArray = P[j];
                int n2 = j;
                dArray[n2] = dArray[n2] + (double)y_j;
                int k = j + 1;
                while (k < y.indices.length) {
                    boolean y_k = y.contains(j);
                    double[] dArray2 = P[j];
                    int n3 = k++;
                    dArray2[n3] = dArray2[n3] + (double)y_k;
                }
            }
        }
        for (int j = 0; j < L; ++j) {
            P[j][j] = Math.max(P[j][j] / (double)N, 1.0E-4);
            for (int k = j + 1; k < L; ++k) {
                P[j][k] = Math.max(P[j][k] / (double)N, 1.0E-4);
            }
        }
        return P;
    }

    public static double[][] getP(int[][] C, int N) {
        int L = C.length;
        double[][] P = new double[L][L];
        for (int j = 0; j < L; ++j) {
            P[j][j] = Math.max((double)C[j][j] / (double)N, 1.0E-4);
            for (int k = j + 1; k < L; ++k) {
                P[j][k] = Math.max((double)C[j][k] / (double)N, 1.0E-4);
            }
        }
        return P;
    }

    public static int[][] getC(Instances D) {
        int L = D.classIndex();
        int N = D.numInstances();
        int[][] C = new int[L][L];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < L; ++j) {
                int[] nArray = C[j];
                int n = j;
                nArray[n] = nArray[n] + (int)D.instance(i).value(j);
                for (int k = j + 1; k < L; ++k) {
                    int[] nArray2 = C[j];
                    int n2 = k;
                    nArray2[n2] = nArray2[n2] + (D.instance(i).value(j) + D.instance(i).value(k) >= 2.0 ? 1 : 0);
                }
            }
        }
        return C;
    }

    public static double I(int[][] C, int j, int k, int Ncount) {
        double N = Ncount;
        double N_j = Math.max((double)C[j][j], 1.0E-4);
        double N_k = Math.max((double)C[k][k], 1.0E-4);
        double p_5 = N - N_j;
        double p_6 = N - N_k;
        double p_7 = N - (N_j + N_k);
        return 1.0 / N * (-p_5 * Math.log(p_5) - p_6 * Math.log(p_6) + p_7 * Math.log(p_7) + N * Math.log(N));
    }

    public static double H(int[][] C, int j, int k, int Ncount) {
        double N = Ncount;
        double N_j = Math.max((double)C[j][j], 1.0E-4);
        double N_k = Math.max((double)C[k][k], 1.0E-4);
        double N_jk = Math.max((double)C[j][k], 1.0E-4);
        double p_1 = N + N_jk - (N_j + N_k);
        double p_2 = N_k - N_jk;
        double p_3 = N_j - N_jk;
        double p_5 = N - N_j;
        return -1.0 / N * (p_1 * Math.log(p_1) + p_2 * Math.log(p_2) + p_3 * Math.log(p_3) + N_jk * Math.log(N_jk) - p_5 * Math.log(p_5) - N_j * Math.log(N_j));
    }

    public static double[][] I(double[][] P) {
        int L = P.length;
        double[][] M2 = new double[L][L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                M2[j][k] = StatUtils.I(P, j, k);
            }
        }
        return M2;
    }

    public static double I(double[][] P, int j, int k) {
        double I = 0.0;
        double p_x = P[j][j];
        double p_y = P[k][k];
        double p_xy = P[j][k];
        I += p_xy * Math.log(p_xy / (p_x * p_y));
        return I += (1.0 - p_xy) * Math.log((1.0 - p_xy) / ((1.0 - p_x) * (1.0 - p_y)));
    }

    public static double I(Instances D, int j, int k) {
        double I = 0.0;
        for (int x = 0; x < D.attribute(j).numValues(); ++x) {
            double p_x = StatUtils.p(D, j, x);
            for (int y = 0; y < D.attribute(k).numValues(); ++y) {
                double p_y = StatUtils.p(D, k, y);
                double p_xy = StatUtils.P(D, j, x, k, y);
                I += p_xy * Math.log(p_xy / (p_x * p_y));
            }
        }
        return I;
    }

    public static double[][] I(Instances D, int L) {
        double[][] M2 = new double[L][L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                M2[j][k] = StatUtils.I(D, j, k);
            }
        }
        return M2;
    }

    public static double chi2(Instances Y, int j, int k) {
        double chi2 = 0.0;
        for (int j_ = 0; j_ < 2; ++j_) {
            for (int k_ = 0; k_ < 2; ++k_) {
                double E = StatUtils.p(Y, j, j_) * StatUtils.p(Y, k, k_);
                double O = StatUtils.P(Y, j, j_, k, k_);
                chi2 += (O - E) * (O - E) / E;
            }
        }
        return chi2;
    }

    public static double[][] chi2(Instances D) {
        int L = D.classIndex();
        double[][] X = new double[L][L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                X[j][k] = StatUtils.chi2(D, j, k);
            }
        }
        return X;
    }

    public static double[][] chi2(double[][][] M2, double[][][] Exp) {
        int K = M2.length;
        int L = M2[0].length;
        int DoF = K - 1;
        double[][] V = new double[L][L];
        for (int i = 0; i < K; ++i) {
            for (int j = 0; j < L; ++j) {
                int k = j + 1;
                while (k < L) {
                    double J = M2[i][j][k];
                    double E = Exp[i][j][k];
                    double[] dArray = V[j];
                    int n = k++;
                    dArray[n] = dArray[n] + (J - E) * (J - E) / E;
                }
            }
        }
        double p = CRITICAL[DoF];
        for (int j = 0; j < L; ++j) {
            int k = j + 1;
            while (k < L) {
                double[] dArray = V[j];
                int n = k++;
                dArray[n] = dArray[n] - p;
            }
        }
        return V;
    }

    public static double[][] margDepMatrix(Instances D, String op) {
        int L = D.classIndex();
        int N = D.numInstances();
        if (op.equals("C")) {
            int[][] C = StatUtils.getApproxC(D);
            double[][] P = StatUtils.getP(C, N);
            return P;
        }
        if (op.equals("I")) {
            return StatUtils.I(D, L);
        }
        if (op.equals("Ib")) {
            int[][] C = StatUtils.getC(D);
            double[][] P = StatUtils.getP(C, N);
            return StatUtils.I(P);
        }
        if (op.equals("Ibf")) {
            int[][] C = StatUtils.getApproxC(D);
            double[][] P = StatUtils.getP(C, N);
            return StatUtils.I(P);
        }
        if (op.equals("H")) {
            int[][] C = StatUtils.getC(D);
            return StatUtils.H(C, N);
        }
        if (op.equals("H")) {
            int[][] C = StatUtils.getApproxC(D);
            return StatUtils.H(C, N);
        }
        if (op.equals("X")) {
            return StatUtils.chi2(D);
        }
        if (op.equals("F")) {
            double[][] F2 = StatUtils.F(D);
            return F2;
        }
        System.err.println("No operation found; Using empty!");
        return new double[L][L];
    }

    public static double[][] I(int[][] C, int N) {
        int L = C.length;
        double[][] M2 = new double[L][L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                M2[j][k] = StatUtils.I(C, j, k, N);
            }
        }
        return M2;
    }

    public static double[][] H(int[][] C, int N) {
        int L = C.length;
        double[][] M2 = new double[L][L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                M2[j][k] = StatUtils.H(C, j, k, N);
            }
        }
        return M2;
    }

    public static double[][] H(Instances D) {
        int[][] C = StatUtils.getC(D);
        return StatUtils.H(C, D.classIndex());
    }

    private static double f(Instances Y, int j, int k) {
        double E = StatUtils.p(Y, j, 1) * StatUtils.p(Y, k, 1);
        double O = StatUtils.P(Y, j, 1, k, 1);
        return E / O;
    }

    public static double[][] F(Instances D) {
        int L = D.classIndex();
        double[][] M2 = new double[L][L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                M2[j][k] = Math.abs(1.0 - StatUtils.f(D, j, k));
            }
        }
        return M2;
    }

    private static double[] fillError(Result result, int L) {
        double[][] Yprob = result.allPredictions();
        int[][] Ytrue = result.allActuals();
        double[] ts = ThresholdUtils.thresholdStringToArray(result.getInfo("Threshold"), L);
        int[][] Ypred = ThresholdUtils.threshold(Yprob, ts);
        double[] E = new double[L];
        for (int j = 0; j < L; ++j) {
            E[j] = Metrics.P_Hamming(Ytrue, Ypred, j);
        }
        return E;
    }

    public static double[][] condDepMatrix(Instances D, Result result) {
        int L = D.classIndex();
        int N = D.numInstances();
        double[][] T = MLUtils.getYfromD(D);
        double[][] Y = M.threshold(result.allPredictions(), 0.5);
        result.output = Result.getStats(result, "6");
        double[] E = StatUtils.fillError(result, L);
        double[][][] F2 = new double[3][L][L];
        for (int i = 0; i < N; ++i) {
            int[] y = A.toIntArray(Y[i], 0.5);
            int[] t = A.toIntArray(T[i], 0.5);
            for (int j = 0; j < L; ++j) {
                for (int k = j + 1; k < L; ++k) {
                    if (y[j] != t[j] && y[k] != t[k]) {
                        double[] dArray = F2[0][j];
                        int n = k;
                        dArray[n] = dArray[n] + 1.0;
                        continue;
                    }
                    if (y[j] == t[j] && t[k] == y[k]) {
                        double[] dArray = F2[2][j];
                        int n = k;
                        dArray[n] = dArray[n] + 1.0;
                        continue;
                    }
                    double[] dArray = F2[1][j];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        }
        double[][][] E_norm = new double[3][L][L];
        for (int j = 0; j < L; ++j) {
            for (int k = j + 1; k < L; ++k) {
                E_norm[0][j][k] = (double)N * (E[j] * E[k]);
                E_norm[2][j][k] = (double)N * ((1.0 - E[k]) * (1.0 - E[j]));
                E_norm[1][j][k] = (double)N * (E[j] * (1.0 - E[k]) + (1.0 - E[j]) * E[k]);
            }
        }
        return StatUtils.chi2(F2, E_norm);
    }

    public static double[][] LEAD2(Instances D, Result result) {
        int L = D.classIndex();
        int N = D.numInstances();
        double[][] Y = MLUtils.getYfromD(D);
        double[][] Y_ = M.threshold(result.allPredictions(), 0.5);
        double[][] E = M.subtract(Y, Y_);
        double[][] X = new double[L][L];
        for (int j = 0; j < L; ++j) {
            int k = j + 1;
            while (k < L) {
                for (int v : new int[]{0, 1, -1}) {
                    double p_j = StatUtils.p(E, j, v);
                    double p_k = StatUtils.p(E, k, v);
                    double p_jk = StatUtils.P(E, j, v, k, v);
                    double Exp = p_j * p_k;
                    double[] dArray = X[j];
                    int n = k;
                    dArray[n] = dArray[n] + (p_jk - Exp) * (p_jk - Exp) / Exp;
                }
                double[] dArray = X[j];
                int n = k++;
                dArray[n] = dArray[n] - CRITICAL[1];
            }
        }
        return X;
    }

    public static double[][] LEAD(Instances D, Result R, String MDType) {
        int L = D.classIndex();
        int N = D.numInstances();
        double[][] Ytrue = MLUtils.getYfromD(D);
        double[][] Ypred = M.threshold(R.allPredictions(), 0.5);
        double[][] E = M.abs(M.subtract(Ytrue, Ypred));
        Instances D_E = MLUtils.replaceZasClasses(new Instances(D), E, L);
        return StatUtils.margDepMatrix(D_E, MDType);
    }

    public static double[][] LEAD(Instances D, Result result) {
        return StatUtils.LEAD(D, result, "I");
    }

    public static double[][] LEAD(Instances D, Classifier h, Random r) throws Exception {
        Instances D_r = new Instances(D);
        D_r.randomize(r);
        Instances D_train = new Instances(D_r, 0, D_r.numInstances() * 60 / 100);
        Instances D_test = new Instances(D_r, D_train.numInstances(), D_r.numInstances() - D_train.numInstances());
        BR br = new BR();
        br.setClassifier(h);
        Result result = Evaluation.evaluateModel(br, D_train, D_test, "PCut1", "1");
        return StatUtils.LEAD2(D_test, result);
    }

    public static double[][] LEAD(Instances D, Classifier h, Random r, String MDType) throws Exception {
        Instances D_r = new Instances(D);
        D_r.randomize(r);
        Instances D_train = new Instances(D_r, 0, D_r.numInstances() * 60 / 100);
        Instances D_test = new Instances(D_r, D_train.numInstances(), D_r.numInstances() - D_train.numInstances());
        BR br = new BR();
        br.setClassifier(h);
        Result result = Evaluation.evaluateModel(br, D_train, D_test, "PCut1", "1");
        return StatUtils.LEAD(D_test, result, MDType);
    }

    public static void main(String[] args) throws Exception {
        Instances D = Evaluation.getDataset(args);
        int L = D.classIndex();
        double[][] CD = null;
        if (args[2].equals("L")) {
            String I = "I";
            if (args.length >= 3) {
                I = args[3];
            }
            CD = StatUtils.LEAD(D, (Classifier)new SMO(), new Random(), I);
        } else {
            CD = StatUtils.margDepMatrix(D, args[2]);
        }
        System.out.println(M.toString(CD, "M" + args[2]));
    }
}

