/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import meka.core.A;
import meka.core.MLUtils;

public abstract class SuperLabelUtils {
    private static int[][] generatePartition(int num, double[][] M2, Random r) {
        int i;
        int L = M2.length;
        int[] indices = A.make_sequence(L);
        MLUtils.randomize(indices, r);
        ArrayList[] Y_meta = new ArrayList[num];
        for (i = 0; i < num; ++i) {
            Y_meta[i] = new ArrayList();
            Y_meta[i].add(indices[i]);
        }
        for (i = num; i < L; ++i) {
            int idx = 0;
            Y_meta[idx].add(indices[i]);
        }
        return SuperLabelUtils.convertListArrayTo2DArray(Y_meta);
    }

    public static int[][] generatePartition(int L) {
        int[][] partition = new int[L][];
        for (int j = 0; j < L; ++j) {
            partition[j] = new int[]{j};
        }
        return partition;
    }

    public static int[][] generatePartition(int[] indices, Random r) {
        int L = indices.length;
        return SuperLabelUtils.generatePartition(indices, r.nextInt(L) + 1, r);
    }

    public static int[][] generatePartition(int[] indices, int num, Random r) {
        int i;
        int L = indices.length;
        MLUtils.randomize(indices, r);
        ArrayList[] selection = new ArrayList[num];
        for (i = 0; i < num; ++i) {
            selection[i] = new ArrayList();
            selection[i].add(indices[i]);
        }
        for (i = num; i < L; ++i) {
            int idx = r.nextInt(num);
            selection[idx].add(indices[i]);
        }
        return SuperLabelUtils.convertListArrayTo2DArray(selection);
    }

    private static final int[][] convertListArrayTo2DArray(ArrayList<Integer>[] listArray) {
        int num_partitions = listArray.length;
        int[][] array = new int[num_partitions][];
        for (int i = 0; i < listArray.length; ++i) {
            array[i] = A.toPrimitive(listArray[i]);
        }
        return array;
    }

    public static String toString(int[][] partition) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < partition.length; ++i) {
            sb.append(" " + Arrays.toString(partition[i]));
        }
        sb.append(" }");
        return sb.toString();
    }
}

