/*
 * Decompiled with CFR 0.152.
 */
package meka.filters.multilabel;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import meka.classifiers.multitarget.NSR;
import meka.core.MLUtils;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class SuperNodeFilter
extends SimpleBatchFilter {
    protected Instance x_template = null;
    protected int m_P = 0;
    protected int m_N = 0;
    protected int[][] indices = null;
    protected int m_Seed = 0;

    public void setIndices(int[][] n) {
        for (int i = 0; i < n.length; ++i) {
            Arrays.sort(n[i]);
        }
        this.indices = n;
    }

    public void setP(int p) {
        this.m_P = p;
    }

    public int getP() {
        return this.m_P;
    }

    public void setN(int n) {
        this.m_N = n;
    }

    public Instances determineOutputFormat(Instances D) throws Exception {
        Instances D_out = new Instances(D, 0);
        int L = D.classIndex();
        for (int i = 0; i < L - this.indices.length; ++i) {
            D_out.deleteAttributeAt(0);
        }
        return D_out;
    }

    public Instance getTemplate() {
        return this.x_template;
    }

    public Instances process(Instances D) throws Exception {
        int L = D.classIndex();
        D = new Instances(D);
        for (int j = 0; j < L; ++j) {
            D.renameAttribute(j, SuperNodeFilter.encodeClass(j));
        }
        D = SuperNodeFilter.mergeLabels(D, this.indices, this.m_P, this.m_N);
        this.x_template = D.firstInstance();
        this.setOutputFormat(D);
        return D;
    }

    private static String join(int[] objs, String delimiter) {
        if (objs == null || objs.length < 1) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(objs[0]));
        for (int j = 1; j < objs.length; ++j) {
            buffer.append(delimiter).append(String.valueOf(objs[j]));
        }
        return buffer.toString();
    }

    public static String encodeClass(int j) {
        return "c_" + j;
    }

    public static int decodeClass(String a) {
        return Integer.parseInt(a.substring(a.indexOf(95) + 1));
    }

    public static String encodeClass(String c_j, String c_k) {
        return "c_" + SuperNodeFilter.join(SuperNodeFilter.decodeClasses(c_j), "+") + "+" + SuperNodeFilter.join(SuperNodeFilter.decodeClasses(c_k), "+");
    }

    public static String encodeClass(int[] c_) {
        String c = "c_";
        for (int j = 0; j < c_.length; ++j) {
            c = c + c_[j] + "+";
        }
        c = c.substring(0, c.length() - 1);
        return c;
    }

    public static int[] decodeClasses(String a) {
        String[] s = new String(a.substring(a.indexOf(95) + 1)).split("\\+");
        int[] vals = new int[s.length];
        for (int j = 0; j < vals.length; ++j) {
            vals[j] = Integer.parseInt(s[j]);
        }
        return vals;
    }

    public static String encodeValue(String v_j, String v_k) {
        return String.valueOf(v_j) + "+" + String.valueOf(v_k);
    }

    public static String encodeValue(Instance x, int[] indices) {
        String v = "";
        for (int j = 0; j < indices.length; ++j) {
            v = v + x.stringValue(indices[j]) + "+";
        }
        v = v.substring(0, v.length() - 1);
        return v;
    }

    public static String[] decodeValue(String a) {
        return a.split("\\+");
    }

    public static Set<String> getValues(Instances D, int[] indices, int p) {
        HashMap<String, Integer> count = SuperNodeFilter.getCounts(D, indices, p);
        return count.keySet();
    }

    public static HashMap<String, Integer> getCounts(Instances D, int[] indices, int p) {
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (int i = 0; i < D.numInstances(); ++i) {
            String v;
            count.put(v, count.containsKey(v = SuperNodeFilter.encodeValue(D.instance(i), indices)) ? count.get(v) + 1 : 1);
        }
        MLUtils.pruneCountHashMap(count, p);
        return count;
    }

    public static Instances mergeLabels(Instances D, int[][] indices, int p, int n) {
        int j;
        int L = D.classIndex();
        int K = indices.length;
        ArrayList[] values = new ArrayList[K];
        HashMap[] counts = new HashMap[K];
        Instances D_ = new Instances(D);
        for (j = 0; j < L; ++j) {
            D_.deleteAttributeAt(0);
        }
        for (j = 0; j < K; ++j) {
            int[] att = indices[j];
            counts[j] = SuperNodeFilter.getCounts(D, att, p);
            Set vals = counts[j].keySet();
            values[j] = new ArrayList(vals);
            D_.insertAttributeAt(new Attribute(SuperNodeFilter.encodeClass(att), new ArrayList(vals)), j);
        }
        ArrayList<Integer> deleteList = new ArrayList<Integer>();
        for (int i = 0; i < D.numInstances(); ++i) {
            Instance x = D.instance(i);
            for (int j2 = 0; j2 < K; ++j2) {
                String y = SuperNodeFilter.encodeValue(x, indices[j2]);
                try {
                    D_.instance(i).setValue(j2, y);
                    continue;
                }
                catch (Exception e) {
                    deleteList.add(i);
                    String[] y_close = NSR.getTopNSubsets(y, counts[j2], n);
                    for (int m = 0; m < y_close.length; ++m) {
                        Instance x_copy = (Instance)D_.instance(i).copy();
                        x_copy.setValue(j2, y_close[m]);
                        x_copy.setWeight(1.0 / (double)y_close.length);
                        D_.add(x_copy);
                    }
                }
            }
        }
        Collections.sort(deleteList, Collections.reverseOrder());
        Iterator i$ = deleteList.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            D_.delete(i);
        }
        D_.setClassIndex(K);
        D = null;
        return D_;
    }

    public static Instances mergeLabels(Instances D, int j, int k, int p) {
        int L = D.classIndex();
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        Set<String> values = new HashSet<String>();
        for (int i = 0; i < D.numInstances(); ++i) {
            String v = SuperNodeFilter.encodeValue(D.instance(i).stringValue(j), D.instance(i).stringValue(k));
            String w = "" + (int)D.instance(i).value(j) + (int)D.instance(i).value(k);
            count.put(v, count.containsKey(v) ? count.get(v) + 1 : 1);
            values.add(SuperNodeFilter.encodeValue(D.instance(i).stringValue(j), D.instance(i).stringValue(k)));
        }
        System.out.print("pruned from " + count.size() + " to ");
        MLUtils.pruneCountHashMap(count, p);
        String y_max = (String)MLUtils.argmax(count);
        System.out.println("" + count.size() + " with p = " + p);
        System.out.println("" + count);
        values = count.keySet();
        D.insertAttributeAt(new Attribute(SuperNodeFilter.encodeClass(D.attribute(j).name(), D.attribute(k).name()), new ArrayList(values)), L);
        for (int i = 0; i < D.numInstances(); ++i) {
            Instance x = D.instance(i);
            String y_jk = SuperNodeFilter.encodeValue(x.stringValue(j), x.stringValue(k));
            try {
                x.setValue(L, y_jk);
                continue;
            }
            catch (Exception e) {
                String[] y_close = SuperNodeFilter.getNeighbours(y_jk, count, 1);
                int max_c = 0;
                for (String y_ : y_close) {
                    int c = count.get(y_);
                    if (c <= max_c) continue;
                    max_c = c;
                    y_max = y_;
                }
                x.setValue(L, y_max);
            }
        }
        D.deleteAttributeAt(k > j ? k : j);
        D.deleteAttributeAt(k > j ? j : k);
        D.setClassIndex(L - 1);
        return D;
    }

    public static String[] getNeighbours(String y, ArrayList<String> S, int n) {
        String[] ya = SuperNodeFilter.decodeValue(y);
        ArrayList<String> Y = new ArrayList<String>();
        for (String y_ : S) {
            if (MLUtils.bitDifference(ya, SuperNodeFilter.decodeValue(y_)) > n) continue;
            Y.add(y_);
        }
        return Y.toArray(new String[Y.size()]);
    }

    public static String[] getNeighbours(String y, HashMap<String, Integer> S, int n) {
        return SuperNodeFilter.getNeighbours(y, new ArrayList<String>(S.keySet()), n);
    }

    public String globalInfo() {
        return "A SuperNode Filter";
    }

    public static void main(String[] argv) {
        try {
            String fname = Utils.getOption((char)'i', (String[])argv);
            Instances D = new Instances((Reader)new BufferedReader(new FileReader(fname)));
            SuperNodeFilter f = new SuperNodeFilter();
            int c = Integer.parseInt(Utils.getOption((char)'c', (String[])argv));
            D.setClassIndex(c);
            System.out.println("" + f.process(D));
        }
        catch (Exception e) {
            System.err.println("");
            e.printStackTrace();
        }
    }
}

