/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import meka.filters.unsupervised.attribute.MekaClassAttributes;
import meka.gui.explorer.AbstractThreadedExplorerTab;
import meka.gui.explorer.Explorer;
import meka.gui.goe.GenericObjectEditor;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.AttributeSelectionPanel;
import weka.gui.AttributeSummaryPanel;
import weka.gui.InstancesSummaryPanel;

public class PreprocessTab
extends AbstractThreadedExplorerTab {
    private static final long serialVersionUID = -7524660995639441810L;
    protected GenericObjectEditor m_GenericObjectEditor;
    protected JButton m_ButtonApplyFilter;
    protected JPanel m_PanelSplit;
    protected AttributeSelectionPanel m_PanelAttributes;
    protected JButton m_ButtonRemoveAttributes;
    protected InstancesSummaryPanel m_PanelDataSummary;
    protected AttributeSummaryPanel m_PanelAttributeSummary;
    protected AttributeSelectionPanel m_PanelClassAttributes;
    protected JButton m_ButtonSetClassAttributes;

    public PreprocessTab(Explorer owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_GenericObjectEditor = new GenericObjectEditor(true);
        this.m_GenericObjectEditor.setClassType(Filter.class);
        this.m_GenericObjectEditor.setValue(new AllFilter());
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Filter"));
        this.add((Component)panel, "North");
        panel.add((Component)this.m_GenericObjectEditor.getCustomPanel(), "Center");
        this.m_ButtonApplyFilter = new JButton("Apply");
        this.m_ButtonApplyFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessTab.this.getOwner().addUndoPoint();
                PreprocessTab.this.filterData((Filter)PreprocessTab.this.m_GenericObjectEditor.getValue(), null);
            }
        });
        panel.add((Component)this.m_ButtonApplyFilter, "East");
        this.m_PanelSplit = new JPanel(new GridLayout(1, 2));
        this.add((Component)this.m_PanelSplit, "Center");
        JPanel panelLeft = new JPanel(new BorderLayout());
        JPanel panelRight = new JPanel(new BorderLayout());
        this.m_PanelSplit.add(panelLeft);
        this.m_PanelSplit.add(panelRight);
        this.m_PanelDataSummary = new InstancesSummaryPanel();
        this.m_PanelDataSummary.setBorder((Border)BorderFactory.createTitledBorder("Current data set"));
        panelLeft.add((Component)this.m_PanelDataSummary, "North");
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Attributes"));
        panelLeft.add((Component)panel, "Center");
        this.m_PanelAttributes = new AttributeSelectionPanel();
        this.m_PanelAttributes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lm = (ListSelectionModel)e.getSource();
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    if (!lm.isSelectedIndex(i)) continue;
                    PreprocessTab.this.m_PanelAttributeSummary.setAttribute(i);
                    break;
                }
            }
        });
        panel.add((Component)this.m_PanelAttributes, "Center");
        this.m_ButtonRemoveAttributes = new JButton("Remove");
        this.m_ButtonRemoveAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessTab.this.removeAttributes();
            }
        });
        panel.add((Component)this.m_ButtonRemoveAttributes, "South");
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Classes"));
        panelRight.add((Component)panel, "North");
        this.m_PanelClassAttributes = new AttributeSelectionPanel();
        panel.add((Component)this.m_PanelClassAttributes, "Center");
        this.m_ButtonSetClassAttributes = new JButton("Use class attributes");
        this.m_ButtonSetClassAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessTab.this.useClassAttributes();
            }
        });
        panel.add((Component)this.m_ButtonSetClassAttributes, "South");
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Selected attribute"));
        panelRight.add((Component)panel, "Center");
        this.m_PanelAttributeSummary = new AttributeSummaryPanel();
        panel.add((Component)this.m_PanelAttributeSummary, "Center");
    }

    protected void filterData(final Filter filter, final String newName) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String relName = PreprocessTab.this.getData().relationName();
                    filter.setInputFormat(PreprocessTab.this.getData());
                    Instances filtered = Filter.useFilter((Instances)PreprocessTab.this.getData(), (Filter)filter);
                    if (newName == null) {
                        filtered.setRelationName(relName);
                    } else {
                        filtered.setRelationName(newName);
                    }
                    PreprocessTab.this.getOwner().notifyTabsDataChanged(PreprocessTab.this, filtered);
                    PreprocessTab.this.setData(filtered);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        this.start(run);
    }

    protected void removeAttributes() {
        this.getOwner().addUndoPoint();
        int[] indices = this.m_PanelAttributes.getSelectedAttributes();
        Remove remove = new Remove();
        remove.setAttributeIndicesArray(indices);
        this.filterData((Filter)remove, null);
    }

    protected void useClassAttributes() {
        this.getOwner().addUndoPoint();
        int[] indices = this.m_PanelClassAttributes.getSelectedAttributes();
        StringBuilder range = new StringBuilder();
        for (int index : indices) {
            if (range.length() > 0) {
                range.append(",");
            }
            range.append(index + 1);
        }
        MekaClassAttributes catts = new MekaClassAttributes();
        String newName = this.getData().relationName().replaceFirst(" -C [0-9]+", " -C " + indices.length);
        try {
            catts.setAttributeIndices(range.toString());
            this.filterData((Filter)catts, newName);
        }
        catch (Exception e) {
            System.err.println("Setting of class attributes failed:");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Setting of class attributes failed:\n" + e, "Error", 0);
        }
    }

    @Override
    protected void executionStarted() {
        this.m_ButtonApplyFilter.setEnabled(false);
        this.m_ButtonRemoveAttributes.setEnabled(false);
        this.m_PanelDataSummary.setEnabled(false);
        this.m_PanelAttributes.setEnabled(false);
    }

    @Override
    protected void executionFinished(Throwable t) {
        this.m_ButtonApplyFilter.setEnabled(true);
        this.m_ButtonRemoveAttributes.setEnabled(true);
        this.m_PanelDataSummary.setEnabled(true);
        this.m_PanelAttributes.setEnabled(true);
        if (t != null) {
            System.err.println("Processing failed:");
            t.printStackTrace();
            JOptionPane.showMessageDialog(this, "Processing failed:\n" + t, "Error", 0);
        }
    }

    @Override
    public String getTitle() {
        return "Preprocess";
    }

    @Override
    protected void update() {
        this.m_ButtonApplyFilter.setEnabled(this.hasData());
        this.m_PanelAttributes.setEnabled(this.hasData());
        this.m_PanelDataSummary.setEnabled(this.hasData());
        this.m_ButtonRemoveAttributes.setEnabled(this.hasData());
        this.m_PanelAttributeSummary.setEnabled(this.hasData());
        this.m_PanelClassAttributes.setEnabled(this.hasData());
        this.m_ButtonSetClassAttributes.setEnabled(this.hasData());
        if (this.hasData()) {
            this.m_PanelAttributes.setInstances(this.getData());
            this.m_PanelDataSummary.setInstances(this.getData());
            this.m_PanelAttributeSummary.setInstances(this.getData());
            this.m_PanelClassAttributes.setInstances(this.getData());
        }
    }
}

