/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;

public abstract class AbstractSpreadSheetColumnConverter<T>
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = 8681800940519018023L;
    protected SpreadSheetColumnIndex m_Column;
    protected boolean m_KeepFailed;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("keep-failed", "keepFailed", (Object)false);
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public abstract String columnTipText();

    public void setKeepFailed(boolean value) {
        this.m_KeepFailed = value;
        this.reset();
    }

    public boolean getKeepFailed() {
        return this.m_KeepFailed;
    }

    public String keepFailedTipText() {
        return "Whether to keep the original value of cells which conversion has failed rather than setting them to missing.";
    }

    protected void preConvert(SpreadSheet input) {
        this.m_Column.setSpreadSheet(input);
    }

    protected abstract void convert(Cell var1, Cell var2) throws Exception;

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        this.preConvert(input);
        SpreadSheet result = this.m_NoCopy ? input : input.getHeader();
        int index = this.m_Column.getIntIndex();
        for (int r = 0; r < input.getRowCount() && !this.m_Stopped; ++r) {
            DataRow row = input.getRow(r);
            DataRow newRow = this.m_NoCopy ? row : result.addRow();
            for (int i = 0; i < input.getColumnCount(); ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) continue;
                Cell newCell = newRow.addCell(i);
                if (cell.isMissing()) {
                    newCell.setMissing();
                    continue;
                }
                if (i == index) {
                    try {
                        this.convert(cell, newCell);
                    }
                    catch (Exception e) {
                        this.getLogger().severe("Failed to convert value '" + cell.getContent() + "' at " + SpreadSheet.getCellPosition((int)r, (int)i));
                        if (this.m_KeepFailed) {
                            newCell.assign(cell);
                            continue;
                        }
                        newCell.setMissing();
                    }
                    continue;
                }
                newCell.assign(cell);
            }
        }
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }
}

