/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.statistic;

import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;

public abstract class AbstractColumnStatistic
extends AbstractOptionHandler {
    private static final long serialVersionUID = -7187115330070305271L;
    protected String m_LastError;

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    protected String check(SpreadSheet sheet, int colIndex) {
        String result = null;
        if (sheet == null) {
            result = "No data provided!";
        }
        if (result == null && colIndex >= sheet.getColumnCount()) {
            result = "Column index out of bounds: " + colIndex;
        }
        return result;
    }

    protected SpreadSheet createOutputHeader() {
        SpreadSheet result = new SpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("K").setContent("Key");
        row.addCell("V").setContent("Value");
        return result;
    }

    protected abstract void preVisit(SpreadSheet var1, int var2);

    protected abstract void doVisit(Row var1, int var2);

    protected abstract SpreadSheet postVisit(SpreadSheet var1, int var2);

    protected SpreadSheet doGenerate(SpreadSheet sheet, int colIndex) {
        this.preVisit(sheet, colIndex);
        for (Row row : sheet.rows()) {
            this.doVisit(row, colIndex);
        }
        return this.postVisit(sheet, colIndex);
    }

    public SpreadSheet generate(SpreadSheet sheet, int colIndex) {
        SpreadSheet result = null;
        this.m_LastError = this.check(sheet, colIndex);
        if (this.m_LastError == null && (result = this.doGenerate(sheet, colIndex)) == null && this.m_LastError == null) {
            this.m_LastError = "Error occurred generating statistics!";
        }
        return result;
    }
}

