/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.statistic;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.statistic.AbstractColumnStatistic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class LabelCounts
extends AbstractColumnStatistic {
    private static final long serialVersionUID = 330391755072250767L;
    protected String m_Prefix;
    protected HashMap<String, Integer> m_Counts;

    public String globalInfo() {
        return "Counts how often a label (ie string) occurs.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the label, eg, to distinguish them from other statistics.";
    }

    @Override
    protected void preVisit(SpreadSheet sheet, int colIndex) {
        this.m_Counts = new HashMap();
    }

    @Override
    protected void doVisit(Row row, int colIndex) {
        if (row.hasCell(colIndex) && row.getCell(colIndex).getContentType() == Cell.ContentType.STRING) {
            String label = row.getCell(colIndex).getContent();
            if (!this.m_Counts.containsKey(label)) {
                this.m_Counts.put(label, 1);
            } else {
                this.m_Counts.put(label, this.m_Counts.get(label) + 1);
            }
        }
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int colIndex) {
        SpreadSheet result = this.createOutputHeader();
        ArrayList<String> labels = new ArrayList<String>(this.m_Counts.keySet());
        Collections.sort(labels);
        for (String label : labels) {
            DataRow row = result.addRow();
            row.addCell(0).setContent(this.m_Prefix + label);
            row.addCell(1).setContent(this.m_Counts.get(label));
        }
        this.m_Counts = null;
        return result;
    }
}

